/***************************************************************************
 *   Copyright (C) 2005,2006,2007 by Siraj Razick                          *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/


#include "config.h"

#include "vistabar.h"
#include "../imagesource/bbg.xpm"
#include "../imagesource/top.xpm"
#include "../imagesource/bot.xpm"
#include "../imagesource/find.xpm"
#include "../imagesource/lock.xpm"
#include "../imagesource/logout.xpm"
#include "../imagesource/appfind.xpm"
#include "../imagesource/listboxbg.xpm"
#include "../imagesource/tilenormal.xpm"
#include "../imagesource/tilehover.xpm"
#include "../imagesource/menu_top_image_person.xpm"

#include "qapplication.h"
#include "qcursor.h"
#include "spinxbutton.h"

vista::vista (QWidget * parent, const char *name, WFlags fl):
QWidget (parent, name,
	 WStyle_Customize | WRepaintNoErase | WStyle_NoBorder |
	 WDestructiveClose | WStyle_StaysOnTop | Qt::WPaintDesktop)
{


  parentRef = parent;
  readConfig ();
  zoomWidth = 32;
  zoomHeight = 32;
  prv = "";
  kmenueditroot = "";
  j = 1;


  backbg = new QLabel (this, "backbg");
  backbg->setPixmap (QImage (bbg));
  backbg->setScaledContents (TRUE);

  tab = new QWidgetStack (this, "tabWidget2");
  tab->setPaletteBackgroundPixmap (QImage (bbg));


  tabindex = new KbfxSpinxListBox (this, "tabindex");
  widgetarray[0] = new QWidget (tab, "tab");
  tabindex->setVariableHeight (TRUE);
  tabindex->setRowMode (QListBox::Variable);

  topbg = new KbfxSpixTop (this, "topbg");
  topbg->setPixmap (QImage (top));
  topbg->setScaledContents (TRUE);


/* icon view properties */
  list1 = new KbfxSpinxListBox (widgetarray[0], "List view");
  tab->addWidget (widgetarray[0], 0);
  VistaListBoxItem *home = new VistaListBoxItem ();
  home->setLabelText (new QString ("Recently Used"));
  tabindex->insertItem (home, 0);
  tabindex->setType (1);

/* end icon view */

  botbg = new QLabel (this, "botbg");
  botbg->setPixmap (QImage (bot));
  botbg->setScaledContents (TRUE);

  place = new QWidget (this, "tm");
  listbar = new KHistoryCombo (place, "search");
  logoutbtn = new SpinxButton (botbg, "Logout");
  lockbtn = new SpinxButton (botbg, "lock");

  connectSignalsWithSlots (parent);
  createApplicationList ();
  clearWState (WState_Polished);
  list1->setSelectionMode (QListBox::Single);


}

void
vista::closeMenu (QListBoxItem * item)
{
  VistaListBoxItem *_item = (VistaListBoxItem *) item;
  if (_item->getType () != 3)
    parentRef->hide ();
}

void
vista::connectSignalsWithSlots (QWidget * ref)
{

  connect (list1, SIGNAL (onItem (QListBoxItem *)), this,
	   SLOT (mouseOverItemSlot (QListBoxItem *)));
  connect (list1, SIGNAL (clicked (QListBoxItem *)),
	   this, SLOT (startApp (QListBoxItem *)));
  connect (list1, SIGNAL (clicked (QListBoxItem *)), this,
	   SLOT (closeMenu (QListBoxItem *)));
  connect (list1, SIGNAL (dragDone (QListBoxItem *)), this,
	   SLOT (closeMenu (QListBoxItem *)));

  connect (listbar, SIGNAL (returnPressed (const QString &)), this,
	   SLOT (startApp (const QString &)));
  connect (listbar, SIGNAL (returnPressed ()), ref, SLOT (hide ()));
  connect (tabindex, SIGNAL (raiseNow (int)), tab, SLOT (raiseWidget (int)));
  connect (tabindex, SIGNAL (raiseNow (int)), tabindex,
	   SLOT (scrollRest (int)));
  connect (list1, SIGNAL (onItem (QListBoxItem *)), this,
	   SLOT (listItemZoomIn (QListBoxItem *)));
  connect (logoutbtn, SIGNAL (clicked ()), this, SLOT (logoutSlot ()));
  connect (lockbtn, SIGNAL (clicked ()), this, SLOT (lockSlot ()));
  connect (topbg, SIGNAL (scroll (int)), list1, SLOT (scroll (int)));
  connect (list1, SIGNAL (showScrollBar ()), topbg, SLOT (scrollArrowsOn ()));

}



void
vista::logoutSlot ()
{
  DCOPRef m_kdesktopKDesktopIface ("kdesktop", "KDesktopIface");
  m_kdesktopKDesktopIface.call ("logout()");


}


void
vista::lockSlot ()
{


  DCOPRef m_kdesktopKScreensaverIface ("kdesktop", "KScreensaverIface");
  m_kdesktopKScreensaverIface.call ("lock()");

  parentRef->hide ();


}


void
vista::readConfig ()
{
  kbFXDebug ("Reading Theme");
}

void
vista::listItemZoomIn (QListBoxItem * item)
{

  if (item == NULL)
    return;
  QListBox *tem = item->listBox ();

  tem->setSelected (item, true);
  tem->setCurrentItem (item);

  int scrollDelta = (-22);

  if (item->next () == 0)
    scrollDelta = 22;

}


void
vista::createApplicationList ()
{
  this->recursiveAppBrowser (KServiceGroup::root ());
  listbar->addToHistory ("kcontrol");
  tabindex->sort(true);
}

void
vista::recursiveAppBrowser (KServiceGroup::Ptr service)
{
  ConfigInit ().read ();
  if (!service || !service->isValid ())
    return;
  KServiceGroup::List list = service->entries (true, true, true, false);

  for (KServiceGroup::List::ConstIterator it = list.begin ();
       it != list.end (); it++)
    {

      KSycocaEntry *p = (*it);
      if (p->isType (KST_KService))
	{
	  int index = j - 1;
	  KService *s = static_cast < KService * >(p);
	  QString details =
	    (s->genericName () == "") ? s->comment () : s->genericName ();

	  addApplication (listarray[index], s->icon (), s->name (),
			  s->desktopEntryPath (), details);
//setsignal

	  connect (listarray[index], SIGNAL (clicked (QListBoxItem *)), this,
		   SLOT (closeMenu (QListBoxItem *)));

	  connect (listarray[index], SIGNAL (dragDone (QListBoxItem *)), this,
		   SLOT (closeMenu (QListBoxItem *)));




	  if (ConfigInit ().m_KbfxHistory.contains (s->name ()) > 5)
	    {
	      addApplication (list1, s->icon (), s->name (),
			      s->desktopEntryPath (), s->comment ());
	    }

	  listbar->addToHistory (s->exec ());
//              qDebug("Desktop entry Name=>"+s->desktopEntryPath());

	  QString sname = p->name ();
	  if (sname.endsWith ("/"))
	    {
	      //TODO add seperator:
	      recursiveAppBrowser (service);
	      return;
	    }

	}
      else if (p->isType (KST_KServiceGroup))
	{

	  QString cur = p->name ();

	  if (prv == "" || !cur.contains (prv))
	    {

	      KServiceGroup *gr = static_cast < KServiceGroup * >(p);
	      kmenueditroot = p->name ();
	      widgetarray[j] = new QWidget (tab, tr (p->name ()));
	      tab->addWidget (widgetarray[j], j);
	      VistaListBoxItem *temp2 = new VistaListBoxItem ();
	      temp2->
		setLabelText (new QString ((gr->caption ().remove ("/"))));
	      tabindex->insertItem (temp2, j);

	      listarray[j] =
		new KbfxSpinxListBox (widgetarray[j], "List view");


	      connect (listarray[j], SIGNAL (onItem (QListBoxItem *)), this,
		       SLOT (mouseOverItemSlot (QListBoxItem *)));
	      connect (listarray[j], SIGNAL (clicked (QListBoxItem *)),
		       this, SLOT (startApp (QListBoxItem *)));
	      connect (listarray[j], SIGNAL (onItem (QListBoxItem *)), this,
		       SLOT (listItemZoomIn (QListBoxItem *)));

	      connect (tabindex, SIGNAL (raiseNow (int)), listarray[j],
		       SLOT (scrollRest (int)));
	      connect (topbg, SIGNAL (scroll (int)), listarray[j],
		       SLOT (scroll (int)));
	      connect (listarray[j], SIGNAL (showScrollBar ()), topbg,
		       SLOT (scrollArrowsOn ()));
	      connect (listarray[j], SIGNAL (hideScrollBar ()), topbg,
		       SLOT (scrollArrowsOff ()));

	      addApplication (listarray[j], "add",
			      tr ("Add More To ") + kmenueditroot,
			      "kmenuedit /" + kmenueditroot.remove ("/"),
			      tr ("Add/Edit Applications "));
	      prv = p->name ();
	      j++;
	      numberoftabs = j;
	    }
	  KServiceGroup *g = static_cast < KServiceGroup * >(p);
	  if (g->childCount () > 0)
	    {
	      recursiveAppBrowser (g);
	      //      addApplication (listarray[j - 1], "next",
	      //                    g->name ().replace ("/", "::"), "dummy",
	      //                    "        ");
	      listarray[j - 1]->setType (3);
	      QString name = g->caption ();
	      addSeparator (listarray[j - 1], name);
	    }
	}


    }


}

void
vista::addSeparator (QListBox * view, QString action)
{

  VistaListBoxItem *Item = new VistaListBoxItem ();
  Item->setLabelText (new QString (action));
  Item->setHeight (27);
  Item->setWidth (193);
  Item->setTilePixmap (RHS_sep);
  Item->setTileHoverPixmap (RHS_sep);
  Item->setType (3);
  view->insertItem (Item, 0);
}


void
vista::listboxMouseOverSlot (QListBoxItem * item)
{
  tabindex->setSelected (item, FALSE);
}


void
vista::sortHistory ()
{
//I have history list box populated
//then I sort the list based on Frquency
//starting from the fifth delete till last iterm
  ConfigInit ().read ();
  QStringList list = ConfigInit ().m_KbfxHistory;
}

vista::~vista ()
{

}

void
vista::addApplication (QListBox * view, QString icon, QString action,
		       QString exec, QString comment)
{

  if (history.contains (action) <= 0)
    {

      KIconLoader *iconload = KGlobal::iconLoader ();
      QString iconfile = iconload->iconPath (icon, KIcon::Desktop, false);
      VistaListBoxItem *Item = new VistaListBoxItem ();
      Item->setLabelText (new QString (action));
      QPixmap iconbg (iconfile);
      if (iconbg.height () < 32 || iconbg.height () > 32)
	{
	  QImage img (iconfile);
	  img = img.smoothScale (32, 32);
	  iconbg = QPixmap (img);
	}
      Item->setHeight (iconbg.height ());
      Item->setWidth (250);
      Item->setLabelIcon (icon);
      Item->setLabelIcon (iconbg);
      Item->setExec (exec);
      Item->setComment (comment);
      Item->setTilePixmap (tileNormal);
      Item->setTileHoverPixmap (tileHover);
      //Item->setType(2);//just a sily number; jus for this small fix.
      view->insertItem (Item, 0);
    }

}


void
vista::KappbarSetTileImages (QPixmap normal, QPixmap hover, QPixmap rhsnormal,
			     QPixmap rhshover, QPixmap sep)
{
  tileNormal = normal;
  tileHover = hover;
  RHS_tileNormal = rhsnormal;
  RHS_tileHover = rhshover;
  RHS_sep = sep;

  if (tileNormal.isNull ())
    tileNormal.convertFromImage (tilenormal);
  if (tileHover.isNull ())
    tileHover.convertFromImage (tilehover);
  if (RHS_sep.isNull ())
    {
      qDebug ("Sep is NULL");
      RHS_sep = tileNormal;
    }
}

void
vista::startApp (QListBoxItem * item)
{

  VistaListBoxItem *_item = (VistaListBoxItem *) item;

  if (_item->getType () == 3)
    return;

  QListBox *_setscroll = item->listBox ();
  _setscroll->scrollBy (0, _setscroll->height ());
  if (_item->getExec ().contains ("kmenuedit"))
    {


      //kiosk mode fix
      KConfig *config = KGlobal::config ();
      KConfigGroupSaver saver (config, "KDE Action Restrictions");

      if (!config->readBoolEntry ("action/menuedit", true))
	return;

      //   kbFXDebug ("Menu Edit called");
      tab->raiseWidget (0);
      tabindex->setTopActive ();
#if HAVE_MANDRAKE
      KRun::runCommand ("menudrake");
#else
      KRun::runCommand (_item->getExec ());
#endif

      addApplication (list1, "knewstuff", "Need to Rebuild Spinx", "dcop",
		      "Click Here to Reload");
      return;
    }
  if (_item->getExec ().contains ("dcop"))
    {


      DCOPRef m_kickerkbfxInterface ("kicker", "kbfxInterface");
      m_kickerkbfxInterface.call ("notifyConfigChange()");
      return;
    }

  ConfigInit ().read ();
  if ((ConfigInit ().m_KbfxHistory.contains (*_item->getText ())) == 0)
    {
      kbFXDebug ("Adding new Item to History");
      addApplication (list1, _item->getIcon (), *_item->getText (),
		      _item->getExec (), _item->getComment ());

    }
  history += *_item->getText ();
  ConfigInit ().m_KbfxHistory =
    QString (ConfigInit ().m_KbfxHistory + "," + *_item->getText () + ",");
  kbFXDebug (ConfigInit ().m_KbfxHistory);
  ConfigInit ().write ();
  QString error;
  QCString dcop;
	int pid=0;
  KApplication::startServiceByDesktopPath (_item->getExec (),
					   QString::null, &error,&dcop,&pid,"",true);
  qDebug ("starting ..." + _item->getExec () + "::status.." + error);

  tab->raiseWidget (0);
  tabindex->setTopActive ();
  tabindex->setCurrentItem (0);
/*
  addApplication (list1, _item->getIcon (), *_item->getText (),
		      _item->getExec (), _item->getComment ());
*/
list1->repaint();

  //     kbFXDebug("****Starting Applicantion==>"+_item->getExec());

}


void
vista::KAppBarSetTheme (QPixmap maintop, QPixmap mainbg, QPixmap tabbg,
			QPixmap mainbot, QPixmap mask, QPixmap listboxbg,
			QPixmap logoutbg, QPixmap logoutbghover,
			QPixmap lockbghover, QPixmap lockbg, QPixmap listbg,
			QPixmap find, QPixmap dudebox)
{

/*
  if (find.isNull ())
    find.convertFromImage (QImage (find_xpm));

  if (logoutbg.isNull ())
    logoutbg.convertFromImage (QImage (logout_xpm));

  if (lockbg.isNull ())
    lockbg.convertFromImage (QImage (lock_xpm));

  if (listboxbg.isNull ())
    listboxbg.convertFromImage (listboxbg_xpm);

  if (listbg.isNull ())
    listbg.convertFromImage (appfind);

*/

  int widthof;
  int heightof;
  if (!mask.isNull ())
    {

      widthof = mask.width ();
      heightof = mask.height ();
      setMinimumWidth (widthof);
      setMinimumHeight (heightof);
      resize (QSize (mask.width (), mask.height ()).
	      expandedTo (minimumSizeHint ()));
    }
  else
    {
      widthof = 300;
      heightof = 400;
      setMinimumWidth (300);
      setMinimumHeight (400);
      resize (QSize (300, 400).expandedTo (minimumSizeHint ()));
    }


  tab->setFrameShape (QFrame::NoFrame);
  tabindex->setFrameShape (QFrame::NoFrame);
  tabindex->setHScrollBarMode (QScrollView::AlwaysOff);

  list1->setFrameShape (QFrame::NoFrame);
  list1->setHScrollBarMode (QScrollView::AlwaysOff);
  
 topbg->setGeometry (QRect (0, 0, widthof, maintop.height ()));
 
 backbg->
    setGeometry (QRect (0, maintop.height (), widthof, mainbg.height ()));
 botbg->
    setGeometry (QRect
		 (0,
		  ((heightof - (topbg->height () + mainbot.height ())) +
		   (topbg->height ())), widthof, mainbot.height ()));
  tab->
    setGeometry (QRect
		 (((mask.width () - (tabbg.width ())) / 2), maintop.height (),
		  (tabbg.isNull ())? widthof - 40 : tabbg.width (),
		  listboxbg.height () + 5));

  tabindex->
    setGeometry (QRect
		 ((mask.width () - (tabbg.width ())) / 2,
		  maintop.height (),
		  tabindex->maxItemWidth (), mainbg.height ()));


  list1->
    setGeometry (QRect
		 (tabindex->width (), 0,
		  (tab->width () - tabindex->width ()), listboxbg.height ()));
  //if (!listboxbg.isNull ())

    logoutbtn->setPixmap (logoutbg, logoutbghover);
    lockbtn->setPixmap (lockbg, lockbghover);

  place->
    setGeometry (QRect
		 (find.width (),
		  (mask.height () - mainbot.height ()) + (mainbot.height () -
							  place->height ()) +
		  1,
		  (botbg->width () - (logoutbg.width () + lockbg.width ())) -
		  30, find.height ()));

  listbar->setGeometry (QRect (0, 0, place->width (), place->height ()));

  logoutbtn->
    setGeometry (QRect
		 (mask.width () - (lockbg.width () + logoutbg.width ()), 0,
		  logoutbg.width (), logoutbg.height ()));
  lockbtn->
    setGeometry (QRect
		 (mask.width () - lockbg.width (), 0, lockbg.width (),
		  lockbg.height ()));
  QWidget *findit = new QWidget (this, tr ("Find %>"));
  findit->setBackgroundPixmap (find);

  findit->
    setGeometry (QRect
		 (4,
		  (mask.height () - mainbot.height ()) + (mainbot.height () -
							  findit->height ()),
		  find.width () + 1, place->height ()));
  if (find.mask ())
    {
      findit->setMask (*find.mask ());
    }

  int x = 1;
  for (; x < numberoftabs; x++)
    {

      listarray[x]->
	setGeometry (QRect
		     ((tabindex->width ()), 0,
		      ((tab->width () - tabindex->width ())),
		      mainbg.height ()));

      listarray[x]->setFrameShape (QFrame::NoFrame);
      listarray[x]->setHScrollBarMode (QScrollView::AlwaysOff);

      int count = listarray[x]->count ();
      for (int i = 0; i < count; i++)
	{
	  QListBoxItem *_item = listarray[x]->item (i);
	  VistaListBoxItem *_it = (VistaListBoxItem *) _item;
	  if (_it->getType () != 3)
	    {
	      _it->setTilePixmap (tileNormal);
	      _it->setTileHoverPixmap (tileHover);
	    }
	  else
	    {
	      _it->setHeight (RHS_sep.height ());
	      _it->setWidth (RHS_sep.width ());

	      _it->setTilePixmap (RHS_sep);
	      _it->setTileHoverPixmap (RHS_sep);

	    }
	}
      //   if (!listboxbg.isNull ())
      listarray[x]->setPaletteBackgroundPixmap (listboxbg);
    }

  list1->setPaletteBackgroundPixmap (listboxbg);
  tabindex->setPaletteBackgroundPixmap (mainbg);


/*********************/
//home menu
  int count = list1->count ();
  for (int i = 0; i < count; i++)
    {
      QListBoxItem *_item = list1->item (i);
      VistaListBoxItem *_it = (VistaListBoxItem *) _item;
      _it->setTilePixmap (tileNormal);
      _it->setTileHoverPixmap (tileHover);
    }


/****************/

  int homecount = tabindex->count ();
  for (int i = 0; i < homecount; i++)
    {
      QListBoxItem *_item = tabindex->item (i);
      VistaListBoxItem *_it = (VistaListBoxItem *) _item;
      _it->setTilePixmap (RHS_tileNormal);
      _it->setTileHoverPixmap (RHS_tileHover);
      _it->setType (1);
    }

//Get the user name 

  KUser *user = new KUser ();
  QString logInName (user->loginName ());
  KIconLoader *iconload = KGlobal::iconLoader ();
  QImage
    UserImage (locate
	       ("data", user->homeDir () + "/.face.icon"));
  UserImage = UserImage.smoothScale (48, 48);

  topbg->setUserImage (QPixmap (UserImage));
  if (dudebox.isNull ())
    topbg->setBoundBox (menu_top_image_person);
  else
    topbg->setBoundBox (dudebox);

  topbg->setBgPixmap ((maintop));
  topbg->repaint ();
  backbg->setPixmap ((mainbg));
  botbg->setPixmap ((mainbot));
  tab->setPaletteBackgroundPixmap (tabbg);

  barheight = heightof;
  resetpending = 0;

}


//DEPRICATED:NEEDs to Remove this 
void
vista::mouseOverItemSlot (QListBoxItem * item)
{

  VistaListBoxItem *_item = (VistaListBoxItem *) item;

}


//DEPRICATED : remove!!!
void
vista::startAction (QListBoxItem * it)
{

  if (it == NULL)
    return;
  VistaListBoxItem *_it = (VistaListBoxItem *) it;
  QString action (*_it->getText ());
  kbFXDebug ("Action");
  kbFXDebug (action);

  if (action == "Logout")
    {

      if (!KApplication ().authorize ("logout"))
	return;
      DCOPRef m_kdesktopKDesktopIface ("kdesktop", "KDesktopIface");
      m_kdesktopKDesktopIface.call ("logout()");
      kbFXDebug ("Action Logout");
      return;
    }
  else if (action == "kcontrol")
    {

      //start kcontrol

    }
  else if (action == "lock")
    {
      if (!KApplication ().authorize ("lock_screen"))
	return;

      DCOPRef m_kdesktopKScreensaverIface ("kdesktop", "KScreensaverIface");
      m_kdesktopKScreensaverIface.call ("lock()");
      kbFXDebug ("Desktop Lock called");


    }
  else
    {
      this->hide ();
      return;

    }
  this->hide ();
}


void
vista::startApp (const QString & x)
{
  KRun::runCommand (x);
}

void
vista::textSlot (const QString & x)
{
}
