//
// C++ Implementation: setfielddlg
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "setfielddlg.h"
#include "bibentrydeftable.h"
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qwhatsthis.h>


SetFieldDlg::SetFieldDlg(bool selected, QWidget *parent, const char *name)
 :KDialogBase ( parent, name , true, i18n ( "Set Field Content" ), KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false )
{
	QWidget* page = new QWidget ( this );
	setMainWidget ( page );
	QVBoxLayout* l = new QVBoxLayout ( page, 0, KDialog::spacingHint() );

	QHBox* box1 = new QHBox ( page );
	box1->setSpacing ( KDialog::spacingHint() );
	
	QLabel *fieldLabel = new QLabel(i18n("Field name:"), box1);
	m_field = new KComboBox(true, box1);
	QWhatsThis::add(m_field, i18n("Enter or select from the list the name of the field you want to change.") );
	l->addWidget(box1);
	fieldLabel->setBuddy(m_field);
	
	QHBox* box2 = new QHBox ( page );
	box2->setSpacing ( KDialog::spacingHint() );
	
	QLabel *editLabel = new QLabel(i18n("Field value:"), box2);
	m_value = new KLineEdit(box2);
	QWhatsThis::add(m_value, i18n("Enter the field value here.") );
	l->addWidget(box2);
	editLabel->setBuddy(m_value);
	
	int width;
	if (fieldLabel->sizeHint().width() > editLabel->sizeHint().width())
		width = fieldLabel->sizeHint().width();
	else
		width = editLabel->sizeHint().width();
	fieldLabel->setFixedWidth(width);
	editLabel->setFixedWidth(width);
		
			
	m_optionGroup = new QVGroupBox(i18n("Apply change to"), page);
    l->addWidget(m_optionGroup);

    m_buttonGroup = new QButtonGroup(page);
    m_allEntrySelect = new QRadioButton(i18n("All references"), m_optionGroup);
	QWhatsThis::add(m_allEntrySelect, i18n("Apply change to all references in the current document.") );
    m_selectedEntrySelect = new QRadioButton(i18n("Only selected references"), m_optionGroup);
	QWhatsThis::add(m_selectedEntrySelect, i18n("Apply change to only selected references in the main list view or in the group view.") );
	m_buttonGroup->hide();

    m_buttonGroup->insert(m_allEntrySelect);
    m_buttonGroup->insert(m_selectedEntrySelect);
	
	if (selected){
	    m_allEntrySelect->setChecked(0);
    	m_selectedEntrySelect->setChecked(1);
		m_selectedEntrySelect->setEnabled(true);
	}
	else{
		m_allEntrySelect->setChecked(1);
    	m_selectedEntrySelect->setChecked(0);	
		m_selectedEntrySelect->setEnabled(false);
	}
	

	m_field->insertStringList( BibEntryDefTable::self()->getFieldNames());	
	
    m_field->setCurrentText("");
	
	QWidget *dumm = new QWidget(box1);
	box1->setStretchFactor(dumm, 1);
	this->setMinimumWidth(300);
}


SetFieldDlg::~SetFieldDlg()
{
}


#include "setfielddlg.moc"
