/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BIBTEXFILEEXPORTERBIBTEX_H
#define BIBTEXFILEEXPORTERBIBTEX_H

#include <element.h>
#include <entryfield.h>
#include <fileexporter.h>

class QChar;

namespace BibTeX
{
    class Comment;
    class Macro;

    /**
    @author Thomas Fischer
    */
    class FileExporterBibTeX : public FileExporter
    {
    public:
        FileExporterBibTeX();
        ~FileExporterBibTeX();

        bool save( QIODevice* iodevice, File* bibtexfile, QStringList *errorLog = NULL );
        bool save( QIODevice* iodevice, Element* element, QStringList *errorLog = NULL );

        void setStringDelimiter( const QChar& stringOpenDelimiter, const QChar& stringCloseDelimiter );
        void setEncoding( File::Encoding encoding );

    public slots:
        void cancel();

    private:
        QChar m_stringOpenDelimiter;
        QChar m_stringCloseDelimiter;
        File::Encoding m_encoding;
        bool cancelFlag;

        bool writeEntry( QTextStream &stream, Entry* entry );
        bool writeMacro( QTextStream &stream, Macro *macro );
        bool writeComment( QTextStream &stream, Comment *comment );
        bool writePreamble( QTextStream &stream, const QString& preamble );

        QString valueToString( const Value *value, const EntryField::FieldType fieldType = EntryField::ftUnknown );

        void escapeLaTeXChars( QString &text );
    };

}

#endif
