/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXENTRYWIDGETUSER_H
#define KBIBTEXENTRYWIDGETUSER_H

#include <qstringlist.h>

#include <kurl.h>

#include <entrywidgettab.h>

class QPushButton;
class KListView;
class QLineEdit;
class KBibTeX::FieldLineEdit;

namespace KBibTeX
{

    class ValueListViewItem;

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class EntryWidgetUser : public EntryWidgetTab
    {
        Q_OBJECT
    public:
        EntryWidgetUser( BibTeX::Entry *entry, BibTeX::File *bibtexfile, bool isReadOnly, QWidget *parent = 0, const char *name = 0 );
        ~EntryWidgetUser();

        bool isModified();

    public slots:
        void updateGUI( BibTeX::Entry::EntryType /*entryType*/, bool enableAll );
        void apply( );
        void reset( );
        void updateWarnings( BibTeX::Entry::EntryType entryType, QListView * /*listViewWarnings*/ );

    private:
        bool m_isModified;

        QPushButton *m_pushButtonUserAdd;
        QPushButton *m_pushButtonUserDelete;
        QPushButton *m_pushButtonUserOpen;
        QLineEdit *m_lineEditUserKey;
        FieldLineEdit *m_fieldLineEditUserValue;
        KListView *m_listViewUserFields;
        QStringList m_deletedUserFields;
        KURL m_internalURL;

        void setupGUI();

    private slots:
        void updateGUI();
        void userFieldExecute( QListViewItem * item );
        void userAddClicked();
        void userDeleteClicked();
        void userOpenClicked();

    };

    class ValueListViewItem : public QListViewItem
    {
    public:
        ValueListViewItem( const QString& title, BibTeX::Value *value, QListView *parent );

        const BibTeX::Value *value();
        QString title();
        void setValue( BibTeX::Value *value );
        void setTitle( const QString &title );

    private:
        QString m_title;
        BibTeX::Value *m_value;

        void setTexts( const QString& title );
    };

}

#endif
