/***************************************************************************
 *   Copyright (C) 2004-2005 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlayout.h>
#include <qtimer.h>
#include <qvalidator.h>
#include <qheader.h>
#include <qlabel.h>

#include <kinputdialog.h>
#include <klistview.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <klocale.h>
#include <kdialog.h>

#include <settings.h>
#include "settingsidsuggestions.h"

namespace KBibTeX
{

    SettingsIdSuggestions::SettingsIdSuggestions( QWidget *parent, const char *name )
            : QWidget( parent, name )
    {
        m_validator = new QRegExpValidator( QRegExp( "[^\\s]+" ), this );
        setupGUI();
    }

    SettingsIdSuggestions::~SettingsIdSuggestions()
    {
        delete m_validator;
    }

    void SettingsIdSuggestions::applyData()
    {
        Settings * settings = Settings::self();

        settings->idSuggestions_formatStrList.clear();
        for ( QListViewItemIterator it( m_listIdSuggestions ); it.current(); ++it )
            settings->idSuggestions_formatStrList.append(( *it )->text( 0 ) );
    }

    void SettingsIdSuggestions::readData()
    {
        Settings * settings = Settings::self();

        m_listIdSuggestions->clear();
        for ( QStringList::ConstIterator it = settings->idSuggestions_formatStrList.begin(); it != settings->idSuggestions_formatStrList.end(); ++it )
        {
            KListViewItem *item = new KListViewItem( m_listIdSuggestions, *it );
            item->setPixmap( 0, SmallIcon( "filter" ) );
        }

        updateGUI();
    }

    void SettingsIdSuggestions::slotConfigChanged()
    {
        emit configChanged();
    }

    void SettingsIdSuggestions::slotNewIdSuggestion()
    {
        KListViewItem * item = new KListViewItem( m_listIdSuggestions, i18n( "a|Y|T" ) );
        item->setPixmap( 0, SmallIcon( "filter" ) );
        m_listIdSuggestions->setSelected( item, TRUE );
        QTimer::singleShot( 100, this, SLOT( slotEditIdSuggestion() ) );
    }

    void SettingsIdSuggestions::slotEditIdSuggestion()
    {
        KListViewItem * item = static_cast<KListViewItem*>( m_listIdSuggestions->selectedItem() );
        if ( item != NULL )
        {
            bool ok;
            QString result = KInputDialog::getText( i18n( "Edit Suggestion" ), i18n( "Edit Suggestion Command:" ), item->text( 0 ), &ok, this, "edit_suggestion", m_validator );
            if ( ok )
            {
                item->setText( 0, result );
                emit configChanged();
            }
        }
        updateGUI();
    }

    void SettingsIdSuggestions::slotDeleteIdSuggestion()
    {
        KListViewItem * item = static_cast<KListViewItem*>( m_listIdSuggestions->selectedItem() );
        if ( item != NULL )
        {
            delete item;
            emit configChanged();
        }
        updateGUI();
    }

    void SettingsIdSuggestions::updateGUI()
    {
        bool selected = m_listIdSuggestions->selectedItem() != NULL;
        m_buttonEditIdSuggestion->setEnabled( selected );
        m_buttonDeleteIdSuggestion->setEnabled( selected );
    }

    void SettingsIdSuggestions::setupGUI()
    {
        QGridLayout * gridLayout = new QGridLayout( this, 5, 2, 0, KDialog::spacingHint(), "gridLayout" );
        gridLayout->setRowStretch( 4, 1 );
        gridLayout->setColStretch( 0, 1 );

        QWidget *container = new QWidget( this );
        gridLayout->addMultiCellWidget( container, 0, 0, 0, 1 );
        QHBoxLayout *contBox = new QHBoxLayout( container, 0, KDialog::spacingHint() );
        QLabel *label = new QLabel( "a", container );
        label->setPixmap( KGlobal::iconLoader() ->loadIcon( "messagebox_warning", KIcon::Desktop ) );
        label->setAlignment( QLabel::AlignLeft | QLabel::AlignTop );
        label->setMinimumWidth( 48 );
        label->setMaximumWidth( 48 );
        contBox->addWidget( label );
        label = new QLabel( i18n( "Editing id suggestion rules is currently recommended for advanced users only. Future versions of KBibTeX may contain a more user friendly interface to edit suggestion rules." ), container );
        label->setAlignment( QLabel::WordBreak | QLabel::AlignTop );
        contBox->addWidget( label );

        m_listIdSuggestions = new KListView( this );
        m_listIdSuggestions->addColumn( i18n( "Id Suggestions" ) );
        m_listIdSuggestions->header()->setClickEnabled( FALSE );
        gridLayout->addMultiCellWidget( m_listIdSuggestions, 1, 4, 0, 0 );
        connect( m_listIdSuggestions, SIGNAL( selectionChanged() ), this, SLOT( updateGUI() ) );
        connect( m_listIdSuggestions, SIGNAL( currentChanged( QListViewItem * ) ), this, SLOT( updateGUI() ) );
        connect( m_listIdSuggestions, SIGNAL( doubleClicked( QListViewItem*, const QPoint &, int ) ), this, SLOT( slotEditIdSuggestion() ) );

        m_buttonNewIdSuggestion = new KPushButton( i18n( "New" ), this );
        gridLayout->addWidget( m_buttonNewIdSuggestion, 1, 1 );
        connect( m_buttonNewIdSuggestion, SIGNAL( clicked() ), this, SLOT( slotNewIdSuggestion() ) );
        m_buttonEditIdSuggestion = new KPushButton( i18n( "Edit" ), this );
        gridLayout->addWidget( m_buttonEditIdSuggestion, 2, 1 );
        connect( m_buttonEditIdSuggestion, SIGNAL( clicked() ), this, SLOT( slotEditIdSuggestion() ) );
        m_buttonDeleteIdSuggestion = new KPushButton( i18n( "Delete" ), this );
        gridLayout->addWidget( m_buttonDeleteIdSuggestion, 3, 1 );
        connect( m_buttonDeleteIdSuggestion, SIGNAL( clicked() ), this, SLOT( slotDeleteIdSuggestion() ) );
    }
}
#include "settingsidsuggestions.moc"
