/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "blogchooser.h"

#include "profileconfig.h"

#include "kbloggerblog.h"

namespace KBlogger
{

BlogChooser::BlogChooser(QWidget *parent): QWidget(parent)
{
    kDebug();
    setupUi(this);
    populateBlogList();
}

BlogChooser::~BlogChooser()
{
    kDebug();
}

void BlogChooser::populateBlogList()
{
    QList<KBloggerBlog> blogList = Backend::self()->getBlogList();
    blogCombo->clear();
    blogCombo->insertItem(0, i18n("Select a blog") );
    for ( int i = 0; i < blogList.size(); ++i) {
        KBloggerBlog blog = blogList.at(i);
        blogCombo->insertItem(blogCombo->count(), blog.icon(), blog.blogname());
    }
}

} //Namespace

#include "blogchooser.moc"
