/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "kbloggerpost.h"


#include <kdebug.h>
#include <kdatetime.h>
#include <kicon.h>

#include "itemsmanager.h"

namespace KBlogger
{

KBloggerPost::KBloggerPost( const QString &blog,
                            const QString &title,
                            const QString &content,
                            const QStringList &categories,
                            const bool isPrivate,
                            const KDateTime &datetime,
                            const QString Id ): BlogPost( Id )
{
    kDebug();

    setTitle( title );
    setBlogName( blog );
    setContent( content );
    setCategories( categories );
    setPrivate( isPrivate );

    if ( title.isEmpty() )
        kWarning() << "Title is empty";
    if ( content.isEmpty() )
        kError() << "Content is empty";
    if ( categories.isEmpty() )
        kWarning() << "Categories is empty";

    setCreationDateTime( datetime );
    setModificationDateTime( datetime );
    setPostId( Id );
    //TODO void setTimeZone( const KTimeZone &tz );
}

KBloggerPost::KBloggerPost( const KBlog::BlogPost* post)
{
    kDebug();
    setTitle( post->title() );
    setBlogName( 0 );
    setContent( post->content() );
    setCategories( post->categories() );
    setPrivate( post->isPrivate() );
    setCreationDateTime( post->creationDateTime() );
    setModificationDateTime( post->modificationDateTime() );
    setPostId( post->postId() );
    setStatus( post->status() );
}

KBloggerPost::~KBloggerPost()
{
    kDebug();
}

void KBloggerPost::setContent(const QString& content)
{
    kDebug();
    KBlog::BlogPost::setContent(content);
    searchMediaInTheContent();
}

QString KBloggerPost::getBlogName()
{
    //kDebug();
    return mBlog;
};

void KBloggerPost::setBlogName(const QString& blogName)
{
    kDebug();
    mBlog = blogName;
}

void KBloggerPost::setDateTimeString(const QString& mDateTime)
{
    kDebug() << mDateTime << endl;
    setCreationDateTime( KDateTime::fromString(mDateTime));
}

QString KBloggerPost::getDateTimeString()
{
    //kDebug();
    return creationDateTime().toString();
}

QWidget* KBloggerPost::container()
{
    kDebug();
    return mContainer;
}

void KBloggerPost::setContainer(QWidget *container)
{
    kDebug();
    mContainer = container;
}

KIcon KBloggerPost::statusIcon()
{
    kDebug();
    QString iconName;
    if ( postId().isEmpty() )
        iconName = "contact-new";//"bookmark-new"; //Local Draft icon
    else
        iconName = "x-office-contact";//"bookmark-new-list";  //Uploaded Post icon
    return KIcon(iconName);
}

bool KBloggerPost::operator==( const KBloggerPost& post) const
{
    kDebug();

    if ( postId() != post.postId() ) {
        kDebug() << "ID fails";
        return false;
    }
    if ( title() != post.title() ) {
        kDebug() << "Title Fails";
        return false;
    }
    if ( content() != post.content() ) {
        kDebug() << "Content Fails";
        return false;
    }
    //if ( isPrivate() == post.isPrivate() ) return false;
    return true;
}

bool KBloggerPost::hasPendingMedia()
{
    kDebug() << "Content:" << content();

    QString c = content();

    //QRegExp rx("\"[^<>]*kblogger-media-([0-9a-f]{4})\"");
    QRegExp rx("kblogger-media-([0-9a-f]{4})");
    QStringList list;
    int pos = 0;

    while ((pos = rx.indexIn(c, pos)) != -1) {
        list << rx.cap(1);
        pos += rx.matchedLength();
    }

    kDebug() << "Media not uploaded" << list;
    for ( int i = 0; i < list.size(); ++i) {
        bool ok;
        QString url;
        quint16 checksum;
        checksum = list.at(i).toInt(&ok, 16);
        if (!ok) {
            kError() << "Impossible convert " << list.at(i) << "to int";
            continue;
        }
        url = ItemsManager::self()->url(mBlog, checksum);
        if (url.isEmpty()) return true;

        kDebug() << QString("kblogger-media-" + list.at(i))
        << "will be replaced with" << url;

        c.replace(QString("kblogger-media-" + list.at(i)), url);

    }
    setContent(c);
    return false;
}

QStringList KBloggerPost::mediaUrlList()
{
    kDebug();
    return uploadedMediaUrlList;
}

void KBloggerPost::searchMediaInTheContent()
{
    QString contentStr = content();
    kDebug() << contentStr;

    QRegExp rx("http://[^\"]*.(jpg|png|gif)"); //FIXME Improve!

    int pos = 0;
    while ((pos = rx.indexIn(contentStr, pos)) != -1) {
        uploadedMediaUrlList << rx.cap(0);
        pos += rx.matchedLength();
    }
    kDebug() << rx.cap(0) << rx.cap(1) << rx.cap(2) << rx.cap(3);
}

}
