
/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef KBLOGGER_POST_H
#define KBLOGGER_POST_H

#include <kblog/blogpost.h>
#include <QStringList>

class KIcon;

namespace KBlogger
{

/**
 @author Antonio Aloisio <antonio.aloisio@kdemail.org>
*/

class KBloggerPost: public KBlog::BlogPost
{

public:
    //FIXME Blogger v.1 doesn't return title & categories.

    KBloggerPost(const QString &blog,
                 const QString &title,
                 const QString &content,
                 const QStringList &categories,
                 const bool isPrivate,
                 const KDateTime &datetime,
                 const QString Id = QString());

    KBloggerPost( const KBlog::BlogPost* post);

    virtual ~KBloggerPost();

    //Overloaded
    void setContent(const QString& content);

    //Blogname functions
    QString getBlogName();
    void setBlogName(const QString& blogName);

    //DateTime functions
    void setDateTimeString(const QString& mDateTime);
    QString getDateTimeString();

    //Returns the a pointer to the widget that contains this post //TODO Use parent?
    QWidget* container();
    void setContainer(QWidget *container);

    //Returns a icon that shows the status (isLocalDraft or isUploadedPost)
    KIcon statusIcon();

    bool operator==( const KBloggerPost& post)const;

    //Returns true if there are some post media doesn't uploaded.
    bool hasPendingMedia();

    //Returns uploadedMediaUrlList
    QStringList mediaUrlList();

private:
    //Scan uploaded media (http://www.yourblog.org/yourmedia.xxx) and insert the url
    // in the uploadedMediaUrlList;
    void searchMediaInTheContent();

    QString mBlog;
    QStringList uploadedMediaUrlList;
    QWidget *mContainer; //NOTE: NEVER DELETE THIS OBJECT //TODO Remove this and use parent?
};

} //Namespace

#endif
