/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef POSTS_LIST_H
#define POSTS_LIST_H

#include <qlist.h>

#include "itemlist.h"
#include "ui_postslistbase.h"
//#include "backendmanager.h" // KBloggerPost

/**
 * Generic Posts List widget.
 * Please don't use this class.
 * Use SentPostsList or LocalDraftPostsList instead.
 */

class KIconLoader;

namespace KBlogger
{

class Backend;
class MainWidget;
class Application;
class KBloggerPost;

class PostsList : public ItemList, public Ui::PostsListBase
{
    Q_OBJECT
public:
    enum EntriesType { sent, local, trashed };
    enum Columns { blog = 0, id, title, categories, date, content, published };

    //Default Constructor
    PostsList( const QString& blogName,
               EntriesType type,
               Application* kbloggerParent,
               QWidget* parent = 0 ); //List entries in upload

    //Default Destructor
    virtual ~PostsList();

    // Remove an entry from the widget
    void removePost( KBloggerPost* postToDelete,  bool delPost = false);

    // store mPostList in a file
    void save(); //save mPostList in a file

    //restore mPostList from a file
    void load();

    //get mPostList
    QList<KBloggerPost*> getEntriesList();

    //Append a entry in the widget
    void appendPost( KBloggerPost* post);

    //@return the number of entries stored in mPostList
    int count();

    //Performs some delete actions on the selected item
    void trashPost();

    //Delete locally a post
    void deletePost();

    // Update search line of kblogger class.
    void updateSearchLine();

    //returns the type of widget that contains this post.
    //EntriesType whereIsThisPost();

public Q_SLOTS:
    //
    void modifyPost();

protected:
    void setFilename(const QString& account, EntriesType type); //sets mFilename variable.
    Backend *mBackend;

private Q_SLOTS:
    //show a preview of mPost
    void previewItem();
    void showPopup(const QPoint& pos);

private:
    KBloggerPost* getCurrentPost();

private:
    MainWidget *mMainWidget;

    Application *mKblogger;
    EntriesType mType;
    QMap<QTreeWidgetItem*, KBloggerPost*> mPostsMap;
    QString mFilename;
};


/**
 *  This widget shows the list of sent entries
 */

class SentPostsList : public PostsList
{
    Q_OBJECT
public:
    SentPostsList( const QString& blogName,
                   Application* kbloggerParent,
                   QWidget* parent = 0 ); //List fetched entries

    virtual ~SentPostsList();

    void updatePostsSentList();

};


/**
 * This Widget shows the draft entries (to upload or not)
 */
class LocalDraftPostsList : public PostsList
{
    Q_OBJECT

public:
    LocalDraftPostsList( const QString& blogName,
                         Application* kbloggerParent,
                         QWidget* parent = 0 ); //List entries in upload
    virtual ~LocalDraftPostsList();
};

/**
 * This Widget shows the draft entries (to upload or not)
 */
class TrashedPostsList : public PostsList
{
    Q_OBJECT

public:
    TrashedPostsList( const QString& blogName,
                      Application* kbloggerParent,
                      QWidget* parent = 0 ); //List entries in upload
    virtual ~TrashedPostsList();
};
} //namespace

#endif
