/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "waitwidget.h"

#include <kdebug.h>

#include <QObject>

#include "backend.h"

/**
 *  This widget will be showed when some jobs are running.
 *  WaitWidget informs the user about jobs that are running
 */


namespace KBlogger
{

WaitWidget *WaitWidget::s_self = 0;

WaitWidget *WaitWidget::self(QWidget* parent)
{
    if ( !s_self ) {
        s_self = new WaitWidget(parent);
        s_self->initialize();
    }
    return s_self;
}

WaitWidget::WaitWidget(QWidget* parent ): QDialog(parent)
{
    kDebug();
    setupUi(this);

}

void WaitWidget::initialize()
{
    //Add default Text
    operationNameLabel->setText(i18n("Please wait..."));
    connect(abortButton, SIGNAL(clicked()),
            Backend::self(), SLOT( stopQueue()) );
    connect(abortButton, SIGNAL(clicked()),
            this, SLOT(close()));
}

WaitWidget::~WaitWidget()
{
    kDebug();
    s_self = 0;
}

void WaitWidget::update( const QString& text, QWidget* parent )
{
    kDebug();
    operationNameLabel->setText(text);
    setParent(parent);
}

void WaitWidget::show()
{
    if ( !isHidden() ) return;
    progressBar->setMaximum( Backend::self()->jobsQueued() );
    progressBar->setValue(0);
    //moveToCenter();
    setModal(true);
    QWidget::show();

}

void WaitWidget::hide()
{
    kDebug();
    QWidget::hide();
    setParent(0);
}

void WaitWidget::jobDone()
{
    kDebug();
    int value = progressBar->value();
    progressBar->setValue(++value);
}
/*
void WaitWidget::moveToCenter()
{
    kDebug();
    QWidget* mParent = qobject_cast<QWidget*>(parent());
    QSize parentSize = mParent->size() / 2;
    QSize thisSize = size() / 2;
    QSize x = parentSize - thisSize;
    move( x.width(), x.height() );
}
*/
}//namespace

#include "waitwidget.moc"

