/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>
   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef BLOG_JOB_H
#define BLOG_JOB_H

#include <QList>
#include <QVariant>
#include <QWidget>

#include <kblog/blog.h>
#include <kjob.h>

class KUrl;

namespace KBlog
{
class BlogPost;
class BlogMedia;
}

namespace KBlogger
{

// class ItemsManager;
class BlogJobPrivate;

/**
  @brief
  This class wraps a KJob around KBlog for Backend, so we can run our tasks
  in BlogJobQueue like we would do with KJobs. It configures KBlog correctly 
  for the different APIs and is the general abstraction layer to KBlog.
*/

class BlogJob : public KJob
{
    Q_OBJECT
    friend class BlogJobPrivate;
public:
    // TODO Split in several list, create, ... jobs
    enum BlogAction{ LIST_BLOGS, LIST_RECENT_POSTS, FETCH_POST, MODIFY_POST,
                       CREATE_POST, REMOVE_POST, LIST_CATEGORIES, CREATE_MEDIA
                     };
    enum BlogAPI{ BLOGGER1, METAWEBLOG, MOVABLETYPE, WORDPRESSBUGGY, GDATA };

    explicit BlogJob( BlogAPI api, KUrl& url, BlogAction action, QVariant& arg,
                 QObject* parent = 0 );

    virtual ~BlogJob();

    void start();
    BlogAPI api();
    BlogAction action();
    void setUsername(const QString& username);
    void setPassword(const QString& password); 
    void setBlogId(const QString& blogId); 

private:
    BlogJobPrivate* d_ptr;
//     Q_PRIVATE_SLOT( d_ptr,
//                     Q_PRIVATE_SLOT( d_ptr, void slotFetchUserInfo( const QList<QVariant> &, const QVariant & ) )
    Q_PRIVATE_SLOT( d_ptr, void slotExitSuccess() )
    Q_PRIVATE_SLOT( d_ptr, void slotExitError( KBlog::Blog::ErrorType type, const QString& message) )
    Q_PRIVATE_SLOT( d_ptr, void slotListBlogs( const QList<QMap<QString,QString> >& list) )
    Q_PRIVATE_SLOT( d_ptr, void slotListRecentPosts( const QList<KBlog::BlogPost>& posts) )
    Q_PRIVATE_SLOT( d_ptr, void slotListCategories( const QList<QMap<QString, QString> >& categories ) )
    Q_PRIVATE_SLOT( d_ptr, void slotCreatePost( KBlog::BlogPost *post) )
    Q_PRIVATE_SLOT( d_ptr, void slotRemovePost( KBlog::BlogPost *post) )
    Q_PRIVATE_SLOT( d_ptr, void slotFetchPost( KBlog::BlogPost *post) )
    Q_PRIVATE_SLOT( d_ptr, void slotModifyPost( KBlog::BlogPost *post) )
    Q_PRIVATE_SLOT( d_ptr, void slotCreateMedia( KBlog::BlogMedia* media) )


Q_SIGNALS:
    void listedRecentPosts( const QList<KBlog::BlogPost>& );
    void listedCategories( const QList<QMap<QString, QString> >& );
};

}//Namespace

#endif

