/***************************************************************************

   Copyright (C) 2005-2007 by Christian Weilbach <christian_weilbach@web.de>
   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef BLOG_JOB_QUEUE_H
#define BLOG_JOB_QUEUE_H

// needed for the ErrorType here only
#include <kblog/blog.h>

class KJob;

namespace KBlogger
{
class BlogJob;

/**
  @brief
  This class is used to store BlogJob[s] and run them all at once in a
  queue. It uses BlogJob to do that.
*/

class BlogJobQueue: public QObject
{
    Q_OBJECT

public:
    BlogJobQueue(QObject *parent = 0);
    ~BlogJobQueue();
    bool addJob(BlogJob* job);
    void run();
    void stop();
    void clear();
    bool isRunning();
    int queueSize();
    QString waitMessage();

protected Q_SLOTS:
    void runsFirstJob();

private Q_SLOTS:
    void slotResult( KJob * job);

private:
    void error(KBlog::Blog::ErrorType, const QString&);

    QList<BlogJob*> mPendingJobs;
    bool mIsRunning;
    bool mIsStopped;

Q_SIGNALS:
    void waitMessage( const QString& );
    void statusMessage( const QString& );
    void error( const QString& );
    void jobsStarted( int );
    void jobDone(KJob*);
    void jobsDone();
};

}

#endif
