/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "blogserver.h"

#include <QList>

#include <kwallet.h>
#include <kicon.h>
#include <kmimetype.h>
#include <kdebug.h>

#include "bloglist.h"

namespace KBlogger
{

BlogServer::BlogServer(): mWallet(0)
{
    kDebug();
    mWallet = KWallet::Wallet::openWallet( "kdewallet", 0 );
    if ( mWallet ) {
        mWallet->setFolder( "kblogger" );
        kDebug() << "Wallet successfully opened.";
    }

}

BlogServer::~BlogServer()
{
    kDebug();
}

void BlogServer::setBlogname( const QString& blogname )
{
    kDebug();
    mBlogname = blogname;
}

QString BlogServer::blogname()
{
    kDebug();
    return mBlogname;
}

void BlogServer::setUrl( const QString& url )
{
    kDebug();
    mUrl = url;
}

KUrl BlogServer::url()
{
    kDebug();
    return mUrl;
}

void BlogServer::setUsername( const QString& username )
{
    kDebug();
    mUsername = username;
}

QString BlogServer::username()
{
    kDebug();
    return mUsername;
}

/*
void BlogServer::setFullName( const QString& fullName )
{
    mFullName = fullName;
}

QString BlogServer::fullName()
{
    return mFullName;
}
*/

QString BlogServer::password()
{
    kDebug();
    QString url = mUrl.url();
    if( url.isEmpty() || mUsername.isEmpty() )
      return QString();
//     Q_ASSERT( !url.isEmpty() ); // asserting is too hard for dummy profiles
//     Q_ASSERT( !mUsername.isEmpty() );
    if (!mWallet ) return QString();
    QString buffer;
    mWallet->readPassword( url + '_' + mUsername, buffer );
    return buffer;
}

void BlogServer::setType( int type)
{
    kDebug();
    mType = type;
}

int BlogServer::type()
{
    kDebug();
    return mType;
}

void BlogServer::setBlogId( const QString& id )
{
    kDebug();
    mBlogId = id;
}

QString BlogServer::blogId()
{
    kDebug();
    return mBlogId;
}

QVariant BlogServer::getBlogServerValue( QString parameter )
{
   kDebug() << "Blog Type:" << type() << "Parameter to get:" << parameter;
   QList<QHash<QString,QVariant> > mBlogList;
   mBlogList= BlogList();
   return mBlogList[ type() ][ parameter ];
}

KIcon BlogServer::icon()
{
    kDebug();
    QString iconName;
    iconName = KMimeType::iconNameForUrl(mUrl);
    kDebug() << "icon=" << iconName;
    if ( iconName == "www" )
        iconName = "kontact-news";
    return KIcon( iconName );
}

} //namespace
