/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef KBLOGGER_H
#define KBLOGGER_H


#include <kxmlguiwindow.h>

#include "profiles/profileconfigdialog.h"
#include "mainwidget.h"
#include "composer/composer.h"
#include "backend/backend.h"

class KToggleAction;
class KTempDir;
class KTreeWidgetSearchLine;

namespace KWallet
{
class Wallet;
}

namespace KIPI
{
class PluginLoader;
}

/**
 * This class serves as the main window for KBlogger.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Antonio Aloisio <gnuton@gnuton.org>
 * @version 1.0-alpha3
 */

namespace KBlogger
{

class Composer;

class MainWindow : public KXmlGuiWindow

{
    Q_OBJECT
public:

    /**
     * Default Constructor
     */
    MainWindow();

    /**
     * Default Destructor
     */
    virtual ~MainWindow();

    void modifyPost(Post* post = 0);
    void updateSearchLine(QTreeWidget *treeWidget = 0); //Move to private + friend with entrieslist?.

private Q_SLOTS:
    void optionsPreferences();
    void createPost();
    void quit();
    void showUploadFileDialog();
    void openMediaWhitExtApp();
    void slotKipiPluginPlug();

private:
    void setupActions();
    void loadPlugins();

private:
    MainWidget *mMainWidget;
    Composer *mComposerDialog;
    KToggleAction *mToolbarAction;
    KToggleAction *mStatusbarAction;
    Backend* mBackend;
    KTreeWidgetSearchLine *mSearchLine;
    KTempDir *mTempDir;
    KIPI::PluginLoader *mKipiPluginLoader;
};

} //namespace
#endif // _KBLOGGER_H_
