/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef IMPORTMEDIADIALOG_H
#define IMPORTMEDIADIALOG_H

#include <KDialog>

#include "media/media.h"


namespace KBlogger
{

class ImportMediaWidget;

/**
 * TODO Remove Singleton. This class is only used by itemsManager
 */

/**
 * @brief
 * Only one instance of this class will run at once, so this class is singleton.
 * Other classes use addUrl to insert the media to download in the importMediaWidget Donwload List.
 * The Download job start to run when the user click OK Button.
 */

class ImportMediaDialog : public KDialog
{
    Q_OBJECT
public:
    //Singleton
    static ImportMediaDialog *self( QWidget* parent = 0 );

    //Default destructor
    virtual ~ImportMediaDialog();

    void addUrl(const QString& url, const QString& blogname, const QString& postId);

public Q_SLOTS:
    void show();
    void accept();
    void reject();
    void close();

private Q_SLOTS:
    void initialize();

private:
    //Costructor
    ImportMediaDialog( QWidget* parent = 0 );
    //Singleton
    static ImportMediaDialog *s_self;

    ImportMediaWidget *widget;
    bool mUrlAdded;
};

} //namespace

#endif
