/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/


#ifndef KBLOGGER_MEDIA_H
#define KBLOGGER_MEDIA_H

#include <QString>

#include <kdatetime.h>
#include <kblog/blogmedia.h>

class KFileItem;
class KIcon;
class KUrl;

namespace KBlogger
{

class Media: public KBlog::BlogMedia
{
public:
    Media(QByteArray& data,
                  const QString& name,
                  const QString& mimetype,
                  const QString& blogname);

    //This Constructor loads data from name var
    Media(const QString& name,
                  const QString& mimetype,
                  const QString& blogname,
                  quint16 checksum);

    ~Media();

    //Used by Load data constructor
    void readData(const KUrl& localFileUrl);

    //Set Data and calculate the checksum
    void setData(const QByteArray& data);

    //Blogname
    QString getBlogname();
    void setBlogname(const QString& blogname);

    //Creation Date
    KDateTime creationDateTime() const;

    //Size
    QString sizeString() const;
    int sizeInt() const;

    //Open the cached file
    void run();

    //returns the name of the cached file
    QString cachedFilename();

    static QString cachePath();

    //returns the url of the cached u
    QString cachedFileUrl();

    //returns the icon of the chached file
    KIcon icon();

    //remove the cached file
    bool removeCachedFile();

    //return the checksum of the cached file
    quint16 checksum();

    //return true if the media data is saved in a cache file
    bool isCached();

    void setUrl(const KUrl& url);

    //Thumbnail managing
    void setFullSizeImage(Media *media);
    Media* fullSizeImage();

    void setThumbnail(Media *media);
    Media* thumbnail();

protected:
    void setChecksum(quint16 checksum);

private:
    void setChecksum(const QByteArray& data);

    void initialize(const QString& blogname,
                    const QString& name,
                    const QString& mimetypestr,
                    const quint16 checksum);

    //Cache functions
    void saveDataInACacheFile();

private:
    QString mBlog;
    QString mCachedFileUrl;
    KFileItem *mCachedFileItem;
    quint16 mChecksum; //CRC-16

    //Thumbnails managing
    Media *mFullSizeImage; //parent
    Media *mThumbnail; //child

};

} //namespace

#endif

