/***************************************************************************
 *   Copyright (C) 2005 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KBSPREDICTORMOLECULEVIEW_H
#define KBSPREDICTORMOLECULEVIEW_H

#include <qgl.h>

#include <predictordata.h>

class KBSPredictorMoleculeView : public QGLWidget
{
  Q_OBJECT
  public:
    KBSPredictorMoleculeView(QWidget *parent=0, char *name=0);
    virtual ~KBSPredictorMoleculeView();
  
    enum Style { Backbone, Spline, Wireframe, Spacefill };
    virtual Style style() const;
    virtual void setStyle(Style style);
    virtual bool isSupportedStyle(Style style) const;
    
    enum Coloring { Monochrome, Group, Shapely, CPK };
    virtual Coloring coloring() const;
    virtual void setColoring(Coloring coloring);
    virtual bool isSupportedColoring(Coloring coloring) const;
    
    virtual void setChain(const QValueList<PredictorMonssterAtom> &chain);
    virtual void setSeq(const PredictorMonssterSeq &seq);
    virtual void setPDB(const PredictorProteinPDB &pdb);
    
    virtual QPixmap pixmap();
    
    virtual bool exportVRML(const QString &fileName);
    virtual bool exportX3D(const QString &fileName);
  
  protected:
    virtual void initializeGL();
    virtual void resizeGL(int width, int height);
    virtual void paintGL();
    
    virtual void keyPressEvent(QKeyEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void mouseReleaseEvent(QMouseEvent *e);
    virtual void mouseMoveEvent(QMouseEvent *e);
    
    static QColor progressColor(double progress);
    static QColor shapelyColor(PredictorAminoAcid aa);
    static QColor cpkColor(const QString &element);
    
    static double atomRadius(const QString &element);
    
    void rotateData(GLfloat *v, GLfloat *tv) const;
    GLfloat transformScalar(GLfloat s) const;
    
    static double distance(GLfloat *v1, GLfloat *v2);
    
  private:
    void rotateData(int dx, int dy);
    void interpolateBackbone();
    
  protected:
    QValueList<PredictorMonssterResidue> m_seq;
    QValueList<PredictorAtomPDB> m_atoms;
    unsigned m_groups;
    
    GLfloat *m_backbone, *m_atom;
    double m_scale;
    
  private:
    Style m_style;
    Coloring m_coloring;
    
    bool m_tracking;
    QPoint m_last;
    
    enum Shape { BallShape, Shapes };
    GLuint m_shapes;
    
    static const QColor s_monochrome;
    static const unsigned s_divisions;
};
    
#endif
