/***************************************************************************
 *   Copyright (C) 2004 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KBSMESSAGEVIEW_H
#define KBSMESSAGEVIEW_H

#include <qmap.h>

#include <klistview.h>

#include <kbsstandardwindow.h>

class KBSBOINCMonitor;

class KBSMessageView : public KBSStandardWindow
{
  Q_OBJECT
  public:
    KBSMessageView(KBSBOINCMonitor *monitor, QWidget *parent=0, const char *name=0);
    virtual ~KBSMessageView();
  
  protected:
    virtual KBSBOINCMonitor *monitor();
    
    virtual QString text();
    
    virtual void setAutoSaveGeometry(const QString &group);
  
  private slots:
    void updateMessages();
    void rpcUpdate();
    void rpcError(const QString &message);
    
    void slotContextMenu(KListView *list, QListViewItem *item, const QPoint &pos);
  
  private:
    void setupView();
  
  protected:
    KListView *m_view;
  
  private:
    class KBSMessageItem : public KListViewItem {
      public:
        KBSMessageItem(QListView *parent, const BOINCMsg &msg);
        virtual QString key(int column, bool ascending) const;
      private:
        BOINCMsg m_msg;
    };
    
    KBSBOINCMonitor *m_monitor;
};

#endif
