/***************************************************************************
 *   Copyright (C) 2005 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KBSPREDICTORMOLECULEVIEW_H
#define KBSPREDICTORMOLECULEVIEW_H

#include <qgl.h>

#include <predictordata.h>

QColor progressColor(double progress);
QColor shapelyColor(PredictorAminoAcid aa);
QColor cpkColor(const QString &element);
QColor monochromeColor();

double atomRadius(const QString &element);
double distance(GLfloat *v1, GLfloat *v2);

class KBSPredictorMoleculeModel : public QObject
{
  Q_OBJECT
  public:
    KBSPredictorMoleculeModel(QObject *parent=0, char *name=0);
    virtual ~KBSPredictorMoleculeModel();
  
    enum Style { Backbone, Spline, Wireframe, Spacefill };
    virtual Style style() const;
    virtual void setStyle(Style style);
    virtual bool isSupportedStyle(Style style) const;
    
    enum Coloring { Monochrome, Group, Shapely, CPK };
    virtual Coloring coloring() const;
    virtual void setColoring(Coloring coloring);
    virtual bool isSupportedColoring(Coloring coloring) const;
    
    virtual void setChain(const QValueList<PredictorMonssterAtom> &chain);
    virtual void setSeq(const PredictorMonssterSeq &seq);
    virtual void setPDB(const PredictorProteinPDB &pdb);
    
    virtual void rotateData(int dx, int dy);
  
    virtual bool exportVRML(const QString &fileName);
    virtual bool exportX3D(const QString &fileName);
    
    friend class KBSPredictorMoleculeView;
  
  signals:
    void styleChanged();
    void coloringChanged();
    void dataChanged();
  
  protected:
  private:
    void interpolateBackbone();
    
  protected:
    QValueList<PredictorMonssterResidue> m_seq;
    QValueList<PredictorAtomPDB> m_atoms;
    unsigned m_groups;
    
    GLfloat *m_backbone, *m_atom;
    
    static const unsigned s_divisions;
  
  private:
    Style m_style;
    Coloring m_coloring;
};

class KBSPredictorMoleculeView : public QGLWidget
{
  public:
    KBSPredictorMoleculeView(QWidget *parent=0, char *name=0);
    virtual ~KBSPredictorMoleculeView();
    
    virtual KBSPredictorMoleculeModel *model() const;
    
    virtual QPixmap pixmap();
    
  protected:
    virtual void initializeGL();
    virtual void resizeGL(int width, int height);
    virtual void paintGL();
    
    virtual void keyPressEvent(QKeyEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void mouseReleaseEvent(QMouseEvent *e);
    virtual void mouseMoveEvent(QMouseEvent *e);
  
  protected:
    double m_scale;
    
  private:
    KBSPredictorMoleculeModel *m_model;
    
    bool m_tracking;
    QPoint m_last;
    
    GLUquadricObj *m_quadric;
    enum Shape { Ball, Shapes };
    GLuint m_base;
};
    
#endif
