/***************************************************************************
 *   Copyright (C) 2005 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KBSPREDICTORTASKMONITOR_H
#define KBSPREDICTORTASKMONITOR_H

#include <kbstaskmonitor.h>

#include <predictordata.h>

class KBSPredictorTaskMonitor : public KBSTaskMonitor
{
  Q_OBJECT
  public:
    KBSPredictorTaskMonitor(unsigned task, KBSBOINCMonitor *parent, const char *name=0);
    
    virtual const PredictorState *state() const;

  protected:
    virtual bool parseFile(KBSFileInfo *file, const QString &fileName);
    
  private:
    bool parseMonssterRestart(const QStringList &lines, PredictorMonssterRestart &restart);
    
  private slots:
    void updateFile(const QString &fileName);
    
  protected:
    PredictorState m_state;
};

#endif
