/***************************************************************************
                          kcdlabel.cpp  -  description
                             -------------------
    begin                : jeu mar 23 20:03:45 CET 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcdlabel.h"
#include "pixmaps.h"
#include <kmainwindow.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <qcolordialog.h>
#include <qmessagebox.h>
#include <qcursor.h>
#include <qpaintdevice.h>
#include <kfiledialog.h>
#include <kurl.h>

KCDLabel::KCDLabel(const char *name) : KMainWindow(0,name)
{
	//---------------------------------------------------
	// setup the background color to white and the title
	//---------------------------------------------------
	setBackgroundColor(white);
	setCaption("KCD-Label");
	setBackgroundMode ( NoBackground );

	//-------------------------------------------	
	// create a status bar
	//-------------------------------------------
	statusbar = statusBar();
//  new KStatusBar(this);
//	setStatusBar( statusbar );
	//--PeP statusbar->setInsertOrder( RightToLeft );
	statusbar->insertItem( "KCDLabel ~ Pascal 'PeP' Panneels", STATUS_MSG, 1, true );	
	statusbar->insertFixedItem( "(1000,1000)", STATUS_MOUSEPOS, true );
	statusbar->insertFixedItem( i18n("Page 0    "), STATUS_PAGE, true  );
	statusbar->setItemAlignment( STATUS_MSG, Qt::AlignLeft );
	//--PeP statusbar->setAlignment( STATUS_PAGE, Right);
	//--PeP statusbar->setAlignment( STATUS_MOUSEPOS, Right);
	
	//-------------------------------------------	
	// create a toolbar
	//-------------------------------------------
	peptoolbar = new KToolBar(this);
	//peptoolbar->insertButton( QPixmap(filenew), FILE_NEW, true, i18n("New Label") );
    addToolBar(peptoolbar);

	toolBar()->insertButton( QPixmap(filenew), FILE_NEW, true, i18n("New Label") );
	toolBar()->insertButton( QPixmap(fileopen), FILE_LOAD, true, i18n("Open Existing Label") );
	toolBar()->insertButton( QPixmap(filesaveas), FILE_SAVE, true, i18n("Save Label") );
	toolBar()->insertSeparator();
	toolBar()->insertButton( QPixmap(fileprint), FILE_PRINT, true, i18n("Print Cover/Booklet") );
	toolBar()->insertSeparator();
	toolBar()->insertButton( QPixmap(eraser), OBJECT_DELETE, true, i18n("Delete Selection") );
	toolBar()->insertSeparator();
	toolBar()->insertButton( QPixmap(penguin), OBJECT_IMAGE, true, i18n("Insert Image") );
	toolBar()->insertButton( QPixmap(text), OBJECT_TEXT, true, i18n("Insert Text") );
	toolBar()->insertButton( QPixmap(centrejust), OBJECT_MULTI_TEXT, true, i18n("Insert Multi Line Text") );
	toolBar()->insertButton( QPixmap(rainbowtext), OBJECT_CURVED_TEXT, true, i18n("Insert Curved Text") );
	toolBar()->enableMoving(true);
//	enableToolBar();
    QObject::connect( toolBar(), SIGNAL(clicked(int)), this, SLOT(slotToolBarClick(int)) );
    QObject::connect( toolBar(), SIGNAL(moved(BarPosition)), this, SLOT(slotToolBarMoved()));

	//-------------------------------------------	
	// create the Popup menus and the main menu
	//-------------------------------------------
	filemenu = new QPopupMenu;
	filemenu->insertItem(i18n("&New"), this, SLOT(slotFileNew()), CTRL+Key_N );
	filemenu->insertItem(i18n("&Open..."), this, SLOT(slotFileOpen()), CTRL+Key_O );
	filemenu->insertItem(i18n("&Save..."), this, SLOT(slotFileSave()), CTRL+Key_S );
	filemenu->insertSeparator();
	filemenu->insertItem(i18n("&Print Cover/Booklet"), this, SLOT(slotFilePrint()), CTRL+Key_P );
	filemenu->insertItem(i18n("Print &Round Label"), this, SLOT(slotFilePrintRound()));
	//filemenu->insertItem(i18n("Print set&up..."), this, SLOT(slotFilePrintSetup()));
	filemenu->insertSeparator();
	filemenu->insertItem(i18n("&Quit"), qApp, SLOT(quit()), CTRL+Key_Q );
	// set some ids
        filemenu->setId(2, FILE_MENU_SAVE );
        filemenu->setId(4, FILE_MENU_PRINTBOOK );
        filemenu->setId(5, FILE_MENU_PRINTROUND );




	editmenu = new QPopupMenu;
	editmenu->insertItem(i18n("C&ut"), this, SLOT(slotCut()), CTRL+Key_X );
	editmenu->insertItem(i18n("&Copy"), this, SLOT(slotCopy()), CTRL+Key_C );	
	editmenu->insertItem(i18n("&Paste"), this, SLOT(slotPaste()), CTRL+Key_V );
	editmenu->setId(0, EDIT_MENU_CUT);
	editmenu->setId(1, EDIT_MENU_COPY);
	editmenu->setId(2, EDIT_MENU_PASTE);

	
	bodymenu = new QPopupMenu;
	bodymenu->insertItem(i18n("&Select source"), this, SLOT(slotBodySelectSource()));
	bodymenu->insertItem(i18n("&Read content"), this, SLOT(slotBodyReadCD()));
	bodymenu->insertSeparator();
		columnmenu = new QPopupMenu;
		columnmenu->insertItem(i18n("&None"), COLUMN_0);
		columnmenu->insertItem(i18n("&1"), COLUMN_1);
		columnmenu->insertItem(i18n("&2"), COLUMN_2);
		columnmenu->insertItem(i18n("&3"), COLUMN_3);
		columnmenu->insertItem(i18n("&4"), COLUMN_4);
		columnmenu->insertItem(i18n("&5"), COLUMN_5);
		columnmenu->insertItem(i18n("&6"), COLUMN_6);
		QObject::connect(columnmenu, SIGNAL(activated(int)), this, SLOT(slotNumberColumn(int)) );
		columnmenu->setItemChecked(COLUMN_0, true);
	bodymenu->insertItem(i18n("Number of &columns"), columnmenu);
		levelmenu = new QPopupMenu;
		levelmenu->insertItem(i18n("&1"), LEVEL_1);
		levelmenu->insertItem(i18n("&2"), LEVEL_2);
		levelmenu->insertItem(i18n("&3"), LEVEL_3);
		levelmenu->insertItem(i18n("&4"), LEVEL_4);
		levelmenu->insertItem(i18n("&All"), LEVEL_ALL);
		QObject::connect(levelmenu, SIGNAL(activated(int)), this, SLOT(slotNumberLevel(int)));
		levelmenu->setItemChecked(LEVEL_ALL, true);
	bodymenu->insertItem(i18n("Number of &directory levels"), levelmenu);
	bodymenu->insertItem(i18n("&Font to use"), this, SLOT(slotBodySelectFont()));
	bodymenu->insertSeparator();
	bodymenu->insertItem(i18n("&Lined"), BODY_LINE);
	bodymenu->setItemChecked(BODY_LINE, true);
	QObject::connect(bodymenu, SIGNAL(activated(int)), this, SLOT(slotBodyLined(int)) );
	bodymenu->insertItem(i18n("Draw &tree lines"), TREE_LINE);
	bodymenu->setItemChecked(TREE_LINE, true);
	QObject::connect(bodymenu, SIGNAL(activated(int)), this, SLOT(slotBodyDrawTree(int)) );
	bodymenu->insertItem(i18n("&Page number"), DISPLAY_PAGENUMBER);
	QObject::connect(bodymenu, SIGNAL(activated(int)), this, SLOT(slotBodyPageNumber(int)) );
	bodymenu->insertSeparator();
	bodymenu->insertItem(i18n("Body &layout"), this, SLOT(slotBodyLayout()));
								

        slidemenu = new QPopupMenu;
        slidemenu->insertItem(i18n( "&Edit slide text" ), this, SLOT(slotSlideEditText()));
	alignmenu = new QPopupMenu;
	alignmenu->insertItem(i18n( "&Left" ), ALIGN_LEFT );
	alignmenu->insertItem(i18n( "&Center"), ALIGN_CENTER );
	alignmenu->insertItem(i18n( "&Right"), ALIGN_RIGHT );
	alignmenu->setItemChecked( ALIGN_LEFT, true );
	QObject::connect( alignmenu, SIGNAL(activated(int)), this, SLOT(slotAlignMenu(int)));
        slidemenu->insertItem(i18n( "&Align"), alignmenu );
        slidemenu->insertItem(i18n( "Transparent Background"), SLIDE_BACKGROUND );
        slidemenu->setItemChecked( SLIDE_BACKGROUND, true );
	QObject::connect(slidemenu, SIGNAL(activated(int)), this, SLOT(slotImageTransparent(int)) );

	imagemenu = new QPopupMenu;
	imagemenu->insertItem(i18n("Insert..."), this, SLOT(slotImageInsert()));
	imagemenu->insertItem(i18n("Delete"), this, SLOT(slotObjectDelete()));
	imagemenu->insertSeparator();
	imagemenu->insertItem(i18n("Resize to full page"), this, SLOT(slotImageResizeFullPage()));
	imagemenu->insertItem(i18n("Resize to ..."), this, SLOT(slotImageResize()));
	imagemenu->insertSeparator();
		alignimagemenu = new QPopupMenu;
		alignimagemenu->insertItem(i18n("&Center of page"), this, SLOT(slotImageAlignCenter()));
	imagemenu->insertItem(i18n("Align"), alignimagemenu);
		orderimagemenu = new QPopupMenu;
		orderimagemenu->insertItem(i18n("Increase"), this, SLOT(slotImageIncreaseOrder()));
		orderimagemenu->insertItem(i18n("Decrease"), this, SLOT(slotImageDecreaseOrder()));
	imagemenu->insertItem(i18n("Order..."), orderimagemenu);
	imagemenu->insertItem(i18n("Draw Tiled"), this, SLOT(slotImageTiled()));
	imagemenu->insertItem(i18n("Transparency"), this, SLOT(slotImageTransparency()));
    // set some ids
	imagemenu->setId(1, IMAGE_MENU_DELETE);
	imagemenu->setId(3, IMAGE_MENU_RESIZEFULL);
	imagemenu->setId(4, IMAGE_MENU_RESIZE);
	imagemenu->setId(6, IMAGE_MENU_ALIGN);
	imagemenu->setId(7, IMAGE_MENU_ORDER);
	imagemenu->setId(8, IMAGE_MENU_TILED);
	imagemenu->setId(9, IMAGE_MENU_TRANSPARENCY);
	imagemenu->setItemChecked(IMAGE_MENU_TRANSPARENCY, true);
        	
	stringmenu = new QPopupMenu;
	stringmenu->insertItem(i18n("Insert single line..."), this, SLOT(slotStringInsert()));
	stringmenu->insertItem(i18n("Insert curved single text ..."), this, SLOT(slotStringInsertCurved()));
	stringmenu->insertItem(i18n("Insert multi line text ..."), this, SLOT(slotStringInsertMulti()));
	stringmenu->insertItem(i18n("Delete"), this, SLOT(slotObjectDelete()));
	stringmenu->insertItem(i18n("Modify"), this, SLOT(slotStringModify()));
	stringmenu->insertSeparator();
		orderstringmenu = new QPopupMenu;
		orderstringmenu->insertItem(i18n("Increase"), this, SLOT(slotStringIncreaseOrder()));
		orderstringmenu->insertItem(i18n("Decrease"), this, SLOT(slotStringDecreaseOrder()));
	stringmenu->insertItem(i18n("Order..."), orderstringmenu);
    // set some ids
	stringmenu->setId(3, STRING_MENU_DELETE);
	stringmenu->setId(4, STRING_MENU_MODIFY);
	stringmenu->setId(6, STRING_MENU_ORDER);
    			
	pagemenu = new QPopupMenu;
	pagemenu->insertItem(i18n("Go to &front page"), this, SLOT(slotPageFront()));
	pagemenu->insertItem(i18n("Go to &back page"), this, SLOT(slotPageBack()));
	pagemenu->insertItem(i18n("Go to &round page"), this, SLOT(slotPageRound()));	
	pagemenu->insertItem(i18n("Go to &page number..."), this, SLOT(slotPageNumber()));
	pagemenu->insertSeparator();	
	pagemenu->insertItem(i18n("Set page background..."), this, SLOT(slotPageColor()));
	pagemenu->insertSeparator();
	pagemenu->insertItem(i18n("Align selected object on the page..."), this, SLOT(slotPageAlignObject()));
	pagemenu->setId(7, PAGE_MENU_ALIGN);
	
	helpmenu = new QPopupMenu;
	helpmenu->insertItem(i18n("Manual"), this, SLOT(slotHelpManual()));
	helpmenu->insertItem(i18n("Thanks..."), this, SLOT(slotHelpThanks()));
	helpmenu->insertItem(i18n("About..."), this, SLOT(slotHelpAbout()));
	
	cddbmenu = new QPopupMenu;
	cddbmenu->insertItem(i18n("&Insert a CDDB entry"), this, SLOT(CDDBAccess()) );
	
	menuBar()->insertItem(i18n("&File"), filemenu);
	menuBar()->insertItem(i18n("&Edit"), editmenu);	
	menuBar()->insertItem(i18n("&Body"), bodymenu);
	menuBar()->insertItem(i18n("&Slide"), slidemenu);
	menuBar()->insertItem(i18n("&Image"), imagemenu);
	menuBar()->insertItem(i18n("S&tring"), stringmenu);	
	menuBar()->insertItem(i18n("&CDDB"), cddbmenu );
	menuBar()->insertItem(i18n("&Page"), pagemenu);
	menuBar()->insertSeparator();
	menuBar()->insertItem(i18n("&Help"), helpmenu);
	//menuBar()->setSeparator( QMenuBar::InWindowsStyle );

	//--PeP menuBar()->setMenuBarPos(KToolBar::Top);
	//--PeP menuBar()->enableFloating(false);
	//--PeP menuBar()->enableMoving(false);
	
	//---------------------------------------------------
	// define popup menus activated by right click
	//---------------------------------------------------
	ImagePopupMenu = new QPopupMenu;
	ImagePopupMenu->insertItem(i18n("Resize to full page"), this, SLOT(slotImageResizeFullPage()));
	ImagePopupMenu->insertItem(i18n("Resize to ..."), this, SLOT(slotImageResize()));
	ImagePopupMenu->insertItem(i18n("Delete"), this, SLOT(slotObjectDelete()));
		orderImagePopupMenu = new QPopupMenu;
		orderImagePopupMenu->insertItem(i18n("Increase"), this, SLOT(slotImageIncreaseOrder()));
		orderImagePopupMenu->insertItem(i18n("Decrease"), this, SLOT(slotImageDecreaseOrder()));
 	ImagePopupMenu->insertItem(i18n("Order..."), orderImagePopupMenu);
		alignImagePopupMenu = new QPopupMenu;
		alignImagePopupMenu->insertItem(i18n("&Center"), this, SLOT(slotImageAlignCenter()));
 		alignImagePopupMenu->insertItem(i18n("Align on page..."), this, SLOT(slotPageAlignObject()));
 	ImagePopupMenu->insertItem(i18n("Align..."), alignImagePopupMenu);
	ImagePopupMenu->insertItem(i18n("Draw Tiled"), this, SLOT(slotImageTiled()));
	ImagePopupMenu->insertItem(i18n("Transparency"), this, SLOT(slotImageTransparency()));
	ImagePopupMenu->setId(5, IMAGE_MENU_TILED);
	ImagePopupMenu->setId(6, IMAGE_MENU_TRANSPARENCY);
	ImagePopupMenu->setItemChecked(IMAGE_MENU_TRANSPARENCY, true);
	
	
	GlobalPopupMenu = new QPopupMenu;
	GlobalPopupMenu->insertItem(i18n("Insert image..."), this, SLOT(slotImageInsert()));
	GlobalPopupMenu->insertItem(i18n("Insert string..."), this, SLOT(slotStringInsert()));
	GlobalPopupMenu->insertItem(i18n("Insert curved string..."), this, SLOT(slotStringInsertCurved()));
	GlobalPopupMenu->insertItem(i18n("Insert multi line text..."), this, SLOT(slotStringInsertMulti()));
	GlobalPopupMenu->insertItem(i18n("Set page background..."), this, SLOT(slotPageColor()));
		
	StringPopupMenu = new QPopupMenu;
	StringPopupMenu->insertItem(i18n("Delete"), this, SLOT(slotObjectDelete()));
	StringPopupMenu->insertItem(i18n("Modify"), this, SLOT(slotStringModify()));
	StringPopupMenu->insertItem(i18n("Align on page..."), this, SLOT(slotPageAlignObject()));
	
	PagePopupMenu = new QPopupMenu;
	PagePopupMenu->insertItem(i18n("Go to &front page"), this, SLOT(slotPageFront()));
	PagePopupMenu->insertItem(i18n("Go to &back page"), this, SLOT(slotPageBack()));
	PagePopupMenu->insertItem(i18n("Go to &round page"), this, SLOT(slotPageRound()));	
	PagePopupMenu->insertItem(i18n("Go to &page number..."), this, SLOT(slotPageNumber()));
	
	//---------------------------------------------------
	// setup the printing stuff
	//---------------------------------------------------
	Printing = false;
	Printer = new KPrinter( true, QPrinter::PrinterResolution );
	Printer->setOrientation( KPrinter::Portrait );
	

	//---------------------------------------------------
	// setup misc stuff
	//---------------------------------------------------
  	ClickedPos = QPoint( -10000, -10000 );  	
  	CurrentPageToDisplay = 0;
  	BackPage.SlideAlignement = AlignLeft;
  	AlignChecked = ALIGN_LEFT;
	ObjectSelected = NULL;
	InitialPosForMove = QPoint(0,0);
	bufferpixmap.resize(size());
	//SlideTransparentBackground=false;
	for (int i=0;i<MAX_PAGES;i++)
		FrontPages.push_back(KCoverPage());
		
	TheBody = new KCoverBody( this, (char *)("/mnt/cdrom"), LEVEL_ALL, COLUMN_0, 2, true, true, false );
    myClipboard.Clean();
		
	//---------------------------------------------------
	// enable/disable some menu entries
	//---------------------------------------------------
	EnableComponents();
	
	//-------------------------------------------------------------------------
	// enable mouse tracking to adjust mouse position field in the status bar
	//-------------------------------------------------------------------------
	setMouseTracking(true);	
	
	//---------------------------------------------------
	// init qimageio extensions
	//---------------------------------------------------
	//qInitImageIO();
 	
}

KCDLabel::~KCDLabel()
{
}

/* user press a key in the widget --> intercept page down/up and the like */
void KCDLabel::keyPressEvent ( QKeyEvent * e )
{
	switch ( e->key() )
		{
		case Key_Down :
		case Key_PageDown :
			ObjectSelected = NULL;
			CurrentPageToDisplay++;
			if (CurrentPageToDisplay==MAX_PAGES+1) CurrentPageToDisplay=0;
			AdjustStatus();
			break;
		case Key_Up :
		case Key_PageUp :
			ObjectSelected = NULL;
			CurrentPageToDisplay--;		
			if (CurrentPageToDisplay==-1) CurrentPageToDisplay=MAX_PAGES;
			AdjustStatus();
			break;
		case Key_Home :
			ObjectSelected = NULL;
			CurrentPageToDisplay = 0;
			AdjustStatus();
			break;
		case Key_End :
			ObjectSelected = NULL;
			CurrentPageToDisplay = MAX_PAGES;
			AdjustStatus();
			break;
		case Key_Delete :
			slotObjectDelete();
			break;
		case Key_Plus :
			if (ObjectSelected)
				switch ( ObjectSelected->GetClassType() )
					{
					case TYPE_CLASS_IMAGE :
						slotImageIncreaseOrder();
						break;
					case TYPE_CLASS_STRING :
					case TYPE_CLASS_CURVED_STRING :
						slotStringIncreaseOrder();
						break;
					case TYPE_CLASS_MULTI_STRING :
					    slotStringMultiIncreaseOrder();
					    break;
					}
			break;
		case Key_Minus :
			if (ObjectSelected)
				switch ( ObjectSelected->GetClassType() )
					{
					case TYPE_CLASS_IMAGE :
						slotImageDecreaseOrder();
						break;
					case TYPE_CLASS_STRING :
					case TYPE_CLASS_CURVED_STRING :
						slotStringDecreaseOrder();
						break;
					case TYPE_CLASS_MULTI_STRING :
					    slotStringMultiDecreaseOrder();
					    break;
					}
			break;
		}
	repaint();
}

/** Open a named cd-label file */
void KCDLabel::NamedFileOpen(KURL url)
{
	char tmp[50];
	int err;
	int pagenumber;
	int version;

    QString Filename = url.path();

    if ( Filename.isEmpty() )
    	return;
	
    // open the file for reading
   	QFile file( Filename );
   	file.open( IO_ReadOnly );
   	
   	// read the signature and version
   	err = file.readBlock( tmp, 9 );
	if ( !strstr(tmp,TAG_SIGNATURE) || (err==-1) )
		return;	// bad file signature or file error
	version = tmp[8];

	// clear some parameters
	columnmenu->setItemChecked(TheBody->Columns, false);	
	levelmenu->setItemChecked( TheBody->Levels, false );
	// load the body
	TheBody->Load( file, version );
	TheBody->BuildResultTree();
	TheBody->MarkPagesToPrint( BackPage, FrontPages );
		
	// read all pages
	err = file.readBlock( tmp, 1 );
	while ( err!=-2 && tmp[0] == TAG_PAGE )
		{
		err = file.readBlock( (char *)&pagenumber, sizeof(int) );
		switch ( pagenumber )
			{
			case -1 :
				BackPage.Load( file, version );
				break;
			case -2 :
				RoundPage.Load( file, version );
				break;
			default :			
        		FrontPages[pagenumber].Load( file, version );
        		break;
			}
    	tmp[0] = '*';
		err = file.readBlock( tmp, 1 );
		}	

	// close the file
	file.close();
	
	// adjust some menu lines according to the new body object
	AdjustBodyMenuParameters();
	
	// repaint the whole page
	repaint();
}


 /** Open a saved cd-label file */
void KCDLabel::slotFileOpen()
{
  QString Filename = KFileDialog::getOpenFileName( 0, "*.kcd", this );
  NamedFileOpen(Filename);
}

/** Save a cd-label into a file */
void KCDLabel::slotFileSave()
{
	char tmp[50];
	
	QString filename = KFileDialog::getSaveFileName( 0, "*.kcd", this );
	QString Filename;
	
	if ( filename.isEmpty() )
		return;
    	
	if ( !filename.contains(".kcd") )
		Filename = filename + QString(".kcd");
	else
		Filename = filename;
		
    // open the file for writing
   	QFile file( Filename );
   	file.open( IO_WriteOnly );
   	// write the signature and version
   	sprintf( tmp, "%s%c", TAG_SIGNATURE, TAG_VERSION );
   	file.writeBlock( tmp, 9 );
	
    // save the body
    TheBody->Save( file );
   	
   	// save the backpage
	BackPage.Save( file, -1 );
	// save the front pages
	for ( int i=0;i<MAX_PAGES;i++ )
		FrontPages[i].Save( file, i );

	RoundPage.Save( file, -2 );
	
    // close the file --> it is finished !!		
	file.close();
}

/** Read the CD Content  */
void KCDLabel::slotBodyReadCD()
{
	QApplication::setOverrideCursor( waitCursor );	
	TheBody->myDirTree->Clear();	
	TheBody->myDirTree->SetBaseDir(TheBody->SourceCD);
	TheBody->myDirTree->Traverse();
	slotNumberLevel(TheBody->Levels);
	// restore normal cursor
	QApplication::restoreOverrideCursor();
}

/** Edit the text for the side of the CD */
void KCDLabel::slotSlideEditText()
{
	// open the slide edit dialog box
	SideEditDlg * dlg = new SideEditDlg(this, i18n("Slide Text"), &BackPage);
	dlg->exec();
	repaint();
}

/** go to the front page */
void KCDLabel::slotPageFront()
{
	CurrentPageToDisplay = 1;
	repaint();
}

/** go to back page */
void KCDLabel::slotPageBack()
{
	CurrentPageToDisplay = 0;
	repaint();
}

/** go to round page */
void KCDLabel::slotPageRound()
{
	CurrentPageToDisplay = ROUND_PAGE;
	repaint();
}

/** go to page number */
void KCDLabel::slotPageNumber()
{
	PageNumberDlg * dlg = new PageNumberDlg(this, i18n("Goto page..."), &CurrentPageToDisplay);
	dlg->exec();
	repaint();
}

/** Print the cd label */
void KCDLabel::slotFilePrint()
{
    if (CurrentPageToDisplay==ROUND_PAGE)
	slotFilePrintRound();
    else
	if ( Printer->setup(this) )
	    {
	     //Printer->setColorMode( KPrinter::GrayScale );

	     int SavedTopX = TopX;
	     int SavedTopY = TopY;
	     TopX = 0; //50;                 // set top left point for drawings on the printer
	     TopY = 0; //50;
	     Printing = true;

	     //--------------------------------------------------
	     // create a paint object related to the printer
	     //--------------------------------------------------
	     QPainter *PrinterPaint = new QPainter;
	     PrinterPaint->begin( Printer );
	     PrinterPaint->setClipping( false );

	     //--------------------------------------------------
	     // print the backpage and the first one from here
	     //--------------------------------------------------

	     // --- backpage
	     QPixmap *bufferpixmaptop = new QPixmap( 2*BACK_HS+BACK_HI+2, BACK_V+2, -1, QPixmap::NoOptim );
	     bufferpixmaptop->fill( /*Qt::white*/ QColor( 255,255,254 ) );
	     QPainter *bufferpaint = new QPainter( bufferpixmaptop );
	     PaintBackPage( bufferpaint );                           // paint the backpage in a buffer
             PrinterPaint->drawPixmap( 0, 0, *bufferpixmaptop );     // draw the pixmap on the printer
	     //PaintBackPage( PrinterPaint );                            // paint the backpage directly on KPrinter
	     
	     // --- first frontpage
	     QPixmap *bufferpixmapbottom = new QPixmap( FRONT_H+2, FRONT_V+2 );
	     bufferpixmapbottom->fill( /*Qt::white*/ QColor( 255,255,254 ) );
	     QPainter *bufferpaint2 = new QPainter( bufferpixmapbottom );
	     PaintFrontPage( bufferpaint2, 0 );   
             PrinterPaint->translate( 0, BACK_V+1 );
             //PaintFrontPage( PrinterPaint, 0 );   
             PrinterPaint->drawPixmap( 0, 0, *bufferpixmapbottom );

             delete bufferpaint;
             delete bufferpaint2;
             delete bufferpixmapbottom;
             delete bufferpixmaptop;

             //----------------------------------------------
             // print the booklet from page 2 starting here
             //----------------------------------------------
             Printing = false;
             int curpage = 1;
             PrinterPaint->translate(0,-BACK_V-1);                   // before it was (0, -BACK_V-10)
             // get the number of pages to print
             unsigned int nbPagesToPrint = GetNumberOfPagesToPrint( 1 );     // starting at page 1

             while ( nbPagesToPrint )
                {
                // ---- print on a new page
                Printing = true;
                Printer->newPage();

                // ---- paint the top part
                bufferpixmaptop = new QPixmap( FRONT_H+2, FRONT_V+2 );
                bufferpixmaptop->fill( /*Qt::white*/ QColor( 255,255,254 ) );
                bufferpaint = new QPainter( bufferpixmaptop );
                PaintFrontPage( bufferpaint, curpage );
                PrinterPaint->drawPixmap( 0, 0, *bufferpixmaptop );
                //PaintFrontPage( PrinterPaint, curpage );
                delete bufferpaint;
                delete bufferpixmaptop;
                if ( FrontPages[curpage].NumberOfObjects || FrontPages[curpage].PageToPrint )
	           nbPagesToPrint--;
                curpage++;


                // ---- paint the bottom part
                QPixmap *bufferpixmapbottom = new QPixmap( FRONT_H+2, FRONT_V+2 );
                bufferpixmapbottom->fill( /*Qt::white*/ QColor( 255,255,254 ) );
                bufferpaint2 = new QPainter( bufferpixmapbottom );
                PaintFrontPage( bufferpaint2, curpage );
                //PaintFrontPage( PrinterPaint, curpage );
                PrinterPaint->translate( 0, FRONT_V+1 );
                PrinterPaint->drawPixmap( 0, 0, *bufferpixmapbottom );
                delete bufferpaint2;
                delete bufferpixmapbottom;
                if ( FrontPages[curpage].NumberOfObjects || FrontPages[curpage].PageToPrint )
	           if ( nbPagesToPrint )
	               nbPagesToPrint--;
                curpage++;

                // ---- retranslate the page
                PrinterPaint->translate( 0, -FRONT_V-1);
                }

             //--------------------------------------------------------
             // end printing
             //--------------------------------------------------------
             PrinterPaint->end();
             Printing = false;
             TopX = SavedTopX;
             TopY = SavedTopY;
             delete PrinterPaint;
	     }
}

/** Print the round cd label */
void KCDLabel::slotFilePrintRound()
{
	static unsigned int Vspace = 7;		// default margin values for HP 895 CXi
	static unsigned int Hspace = 9;
	unsigned int VspacePxl ;
	unsigned int HspacePxl ;
	static bool DrawBorder;

	KPrintRoundDlg dlg(this, i18n("Print Round Label"), &Vspace, &Hspace, &DrawBorder);
  	int result = dlg.exec();
  	if ( result != QDialog::Accepted )
		return;

	// try to convert space given in mm to pixel size
	// by experience, 121 mm is about 343 pixel...
	// (formula could be more complex, with introducing dpi and the likes...but here it is simple and it works ! ;-) )
	VspacePxl = Vspace * 343 / 121;
	HspacePxl = Hspace * 343 / 121;	

	if ( Printer->setup() )
		{
		int SavedTopX = TopX;
		int SavedTopY = TopY;
		TopX = HspacePxl;			// set top left point for drawings on the printer
		TopY = VspacePxl;
		Printing = true;
		QPainter paint;
		paint.begin( Printer );
		RoundPage.DrawBorder = DrawBorder;
		PaintRoundPage( &paint );
		Printing = false;
		paint.end();
		TopX = SavedTopX;
		TopY = SavedTopY;
		RoundPage.DrawBorder = true;
		}
}

/** call the print setup dialog */
void KCDLabel::slotFilePrintSetup()
{
}

/** create a new cd label */
void KCDLabel::slotFileNew()
{
	// ask user if he wants to save current label
	switch( QMessageBox::information( this, i18n("KCDLabel"), i18n("Do you want to save your work before exiting?"), i18n("&Save"), i18n("&Don't Save"), i18n("&Cancel"),0,2) )
		{ // Escape == button 2
		case 0: // Save clicked, Alt-S or Enter pressed.
			slotFileSave();
		case 1: // Don't Save clicked or Alt-D pressed
			{
			// if any selected object, disable it
			ObjectSelected = NULL;
			EnableComponents();
			statusbar->changeItem( "", STATUS_MSG);	// clear the status bar message
			// erase all pages content
			BackPage.Clear();
			for (int i=0;i<MAX_PAGES;i++)
				FrontPages[i].Clear();
			RoundPage.Clear();
			slotNumberColumn(COLUMN_0);
			TheBody->DisplayPageNumber = false;
			repaint();
			}
			break;
		case 2: // Cancel clicked, Alt-C or Escape pressed
			return;
			break;
		}
	EnableComponents();
}

/** Draw the back page of the cd cover */
void KCDLabel::PaintBackPage(QPainter * paint)
{
	// Erase previous drawing and draw the layout
    bufferpixmap.fill(white);

	// paint the page
 	QPoint orig( TopX, TopY );
	BackPage.Paint( paint, orig  );

	// draw the body content
	TheBody->Paint( paint, -1, TopX, TopY, BackPage );
}

/** Draw the back page of the cd cover */
void KCDLabel::PaintFrontPage(QPainter * paint, int page)
{
   	QPoint orig(TopX, TopY);

	// make page not to print now
	FrontPages[page].PageToPrint = false;
	
	// Erase previous drawing and draw the layout
    bufferpixmap.fill(white);

	// Paint the page
	FrontPages[page].Paint(paint, orig);

	// paint the body    	
    TheBody->Paint( paint, page, TopX, TopY, FrontPages[page] );
}

/** Draw the round page of the cd cover */
void KCDLabel::PaintRoundPage(QPainter * paint)
{
	// Erase previous drawing and draw the layout
	bufferpixmap.fill(white);

	// paint the page
 	QPoint orig( TopX, TopY );
	RoundPage.Paint( paint, orig );
}

/** define the paint event */
void KCDLabel::paintEvent( QPaintEvent * event)
{
	QPainter *paint = new QPainter(&bufferpixmap);
	int Hauteur;
	
	switch ( toolBar()->barPos() )
		{
		case KToolBar::Top :
			Hauteur = toolBar()->height();
			break;
		case KToolBar::Bottom :
			Hauteur = -toolBar()->height();
			break;
		default :
			Hauteur = 0;
			break;
		}
	
	switch ( CurrentPageToDisplay )
		{
		case BACK_PAGE :
			TopX = ( width() - (BACK_HI+BACK_HS*2) ) / 2;
			TopY = menuBar()->height() + Hauteur + ( height() - menuBar()->height() - Hauteur - statusbar->height() - BACK_V ) / 2;
			PaintBackPage( paint );
			break;
		case ROUND_PAGE :
			TopX = ( width() - ROUND_BIG ) / 2;
			TopY = menuBar()->height() + Hauteur + ( height() - menuBar()->height() - Hauteur - statusbar->height() - ROUND_BIG ) / 2;
			PaintRoundPage( paint );
			break;

		default :
			TopX = ( width() - FRONT_H ) / 2;
			TopY = menuBar()->height() + Hauteur + ( height() - menuBar()->height() - Hauteur - statusbar->height() - FRONT_V ) / 2;
			PaintFrontPage(paint, CurrentPageToDisplay-1);
			break;
		}
  	
  	if ( ClickedPos==QPoint(-10000, -10000) )
  		ClickedPos = QPoint( width()/2, height()/2 ) - QPoint( TopX, TopY );

    if ( ObjectSelected!=NULL )
    	{
    	if (ObjectSelected->IsMovable )
    		paint->setPen( green );
    	else
    		paint->setPen( red );
    	switch ( ObjectSelected->GetClassType() )
    		{
    		case TYPE_CLASS_IMAGE :
    			paint->drawRect(TopX+ObjectSelected->X-5, TopY+ObjectSelected->Y-5, ObjectSelected->Width()+10, ObjectSelected->Height()+10);
    			break;
    		case TYPE_CLASS_STRING  :
				{
				KCoverString * str = dynamic_cast<KCoverString *>(ObjectSelected);
				paint->drawRect(TopX+str->RealX()-10, TopY+str->RealY()-10, str->Width()+20, str->Height()+20);
				} break;
    		case TYPE_CLASS_CURVED_STRING  :
				{
				KCoverCurvedString * str = dynamic_cast<KCoverCurvedString *>(ObjectSelected);
				paint->drawRect(TopX+str->RealX()-10, TopY+str->RealY()-10, str->Width()+20, str->Height()+20 );
				} break;
    		case TYPE_CLASS_MULTI_STRING  :
				{
				KCoverMultiString * str = dynamic_cast<KCoverMultiString *>(ObjectSelected);
				QFontMetrics fm(*str->Font->Font);
				paint->drawRect(TopX+str->RealX()-10, TopY+str->RealY()-fm.height(), str->Width()+20, str->Height()+fm.height() );
				} break;
				
    		}
    	}
	bitBlt(this, event->rect().topLeft(), &bufferpixmap, event->rect());
	DisplayCurrentPage();
	delete paint;
	AdjustStatus();
	EnableComponents();
}

/** display the current page in the status bar */
void KCDLabel::DisplayCurrentPage() const
{
	char buf[20];
	sprintf(buf,i18n("Page %d"), CurrentPageToDisplay);
	statusbar->changeItem( buf, STATUS_PAGE );
}

/** Select the side text alignement property */
void KCDLabel::slotAlignMenu(int id)
{
    alignmenu->setItemChecked(AlignChecked, false);
    alignmenu->setItemChecked(id, true);
	switch (id)
		{
		case ALIGN_LEFT :
			BackPage.SlideAlignement = AlignLeft;
			break;
		case ALIGN_CENTER :
			BackPage.SlideAlignement = AlignHCenter;
			break;
		case ALIGN_RIGHT :
			BackPage.SlideAlignement = AlignRight;
			break;
		}
	AlignChecked = id;
	repaint();
}

/** insert an image to the current page */
void KCDLabel::slotImageInsert()
{
    //ImageFilename = QFileDialog::getOpenFileName(0, "*", this);
    ImageFilename = (KFileDialog::getImageOpenURL(0, this)).path();
    
    if (ImageFilename.isEmpty())
    	return;
    	
    // add the image to the images list of the current displayed page
	switch (CurrentPageToDisplay)
		{
		case BACK_PAGE :
			BackPage.AddImage( new KCoverImage((const char *)(ImageFilename),0,0,0) );
			break;
		case ROUND_PAGE :
			RoundPage.AddImage( new KCoverImage((const char *)(ImageFilename),0,0,0) );
			break;
		default :
			FrontPages[CurrentPageToDisplay-1].AddImage( new KCoverImage((const char *)(ImageFilename),0,0,0) );
			break;
		}

    repaint();
}

/** Resize an image to the full page size */
void KCDLabel::slotImageResizeFullPage()
{
	// if no object selected or object is not an image, return !
	if ( ObjectSelected==NULL || (ObjectSelected->GetClassType()!=TYPE_CLASS_IMAGE) ) return;
	
	ImageSelected = dynamic_cast<KCoverImage *>(ObjectSelected);
	// we are on backpage
	switch (CurrentPageToDisplay)
		{
		case BACK_PAGE :
			ImageSelected->Scale( BACK_HI+BACK_HS*2, BACK_V );
			break;
		case ROUND_PAGE :
			ImageSelected->Scale( ROUND_BIG, ROUND_BIG );
			break;
		default :
			ImageSelected->Scale( FRONT_H, FRONT_V );
			break;
		}
	repaint();
}

void KCDLabel::mouseDoubleClickEvent(QMouseEvent * event)
{
	// position of the drawn top left corner of the page	
	QPoint clickedpos = event->pos() - QPoint( TopX, TopY );

    if ( ObjectSelected!=NULL )
    	{
    	if (ObjectSelected->IsPointInObject(clickedpos))
    		{
   			ObjectSelected = NULL;
   			repaint();
   			EnableComponents();
   			statusbar->changeItem( "", STATUS_MSG);	// clear the status bar message
   			return;
    		}
    	}
    		
	switch ( CurrentPageToDisplay )
		{
		case BACK_PAGE :
			ObjectSelected = BackPage.GetSelectedObject( clickedpos );
			break;
		case ROUND_PAGE :
			ObjectSelected = RoundPage.GetSelectedObject( clickedpos );
			break;
		default :
			ObjectSelected = FrontPages[CurrentPageToDisplay-1].GetSelectedObject(clickedpos);
			break;
		}
	// set the status bar message
	AdjustStatus();
	repaint();
	EnableComponents();
}

void KCDLabel::mouseMoveEvent( QMouseEvent * event)
{
    QPoint pos = event->pos() - QPoint( TopX, TopY );

    // update the mouse pos status
    char buf[50];
    sprintf(buf,"(%d, %d)", pos.x(), pos.y());
	statusbar->changeItem(buf, STATUS_MOUSEPOS);
    	
	// if leftbutton not pressed --> return
	if ( event->state() != LeftButton )
		return;
			
    if ( InitialPosForMove==QPoint(0,0) )
    	{
    	InitialPosForMove = pos;
    	return;
    	}
    	
    if ( ObjectSelected!=NULL )
    	if ( ObjectSelected->IsMovable )
    		{
	    	//if (!ObjectSelected->IsPointInObject(pos))
    		//	return;
   			ObjectSelected->X += pos.x()-InitialPosForMove.x();
   			ObjectSelected->Y += pos.y()-InitialPosForMove.y();
   			InitialPosForMove = pos;
			AdjustStatus();
   			repaint();
    		}
}

/** mouse press event */
void KCDLabel::mousePressEvent( QMouseEvent * event )
{
	bool bPageMenu = false;
	
	if (event->button()==RightButton )
		{
		ClickedPos = event->pos() - QPoint(TopX, TopY);
		if (ObjectSelected!=NULL)
			if ( ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE )
				ImagePopupMenu->exec(QCursor::pos());
			else
				StringPopupMenu->exec(QCursor::pos());
		else
			{
    		switch ( CurrentPageToDisplay )	
   				{
				case BACK_PAGE :
					bPageMenu =  BackPage.IsPointInPage(ClickedPos);
					break;
				case ROUND_PAGE :
					bPageMenu =  RoundPage.IsPointInPage(ClickedPos);
					break;
				default :			
					bPageMenu = FrontPages[CurrentPageToDisplay-1].IsPointInPage(ClickedPos);
					break;
   				}
   			// display the global menu if click in page or the "goto page" menu 	
			if ( !bPageMenu )
				PagePopupMenu->exec(QCursor::pos());
			else
				GlobalPopupMenu->exec(QCursor::pos());
			}
		}
}

/** mouse button released */
void KCDLabel::mouseReleaseEvent ( QMouseEvent * )
{
	InitialPosForMove = QPoint(0,0);
}

/** manage the resizing of the window */
void KCDLabel::resizeEvent(QResizeEvent * event)
{
	bufferpixmap.resize(event->size());
	KMainWindow::resizeEvent(event);
}
/** make the slide background transparent */
void KCDLabel::slotImageTransparent(int id)
{
	if (id==SLIDE_BACKGROUND)
		{
		BackPage.SlideTransparentBackground = !BackPage.SlideTransparentBackground;
		slidemenu->setItemChecked( SLIDE_BACKGROUND, BackPage.SlideTransparentBackground );
		repaint();
		}
}

/** align the image to the center of the page */
void KCDLabel::slotImageAlignCenter()
{
    if ( ObjectSelected!=NULL )
    	if ( ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE )
    		{
    		ImageSelected = dynamic_cast<KCoverImage *>(ObjectSelected);
    		switch ( CurrentPageToDisplay )	
    				{
    			case BACK_PAGE :
    				ImageSelected->X = ((BACK_HI+2*BACK_HS)/2) - (ImageSelected->Width()/2);
	    			ImageSelected->Y = (BACK_V/2) - (ImageSelected->Height()/2);
	    			break;
    			case ROUND_PAGE :
    				ImageSelected->X = (ROUND_BIG/2) - (ImageSelected->Width()/2);
	    			ImageSelected->Y = (ROUND_BIG/2) - (ImageSelected->Height()/2);
	    			break;
    			default :
    				ImageSelected->X = (FRONT_H/2) - (ImageSelected->Width()/2);
	    			ImageSelected->Y = (FRONT_V/2) - (ImageSelected->Height()/2);
	    			break;
    				}
    		}
    repaint();
}

/** resize image to xxx % or pixels */
void KCDLabel::slotImageResize()
{
	if (ObjectSelected==NULL)
		return;
	if ( ObjectSelected->GetClassType()!=TYPE_CLASS_IMAGE )
		return;
	ScaleImageDlg * dlg = new ScaleImageDlg(this, i18n("Scale"), dynamic_cast<KCoverImage *>(ObjectSelected));
	
	dlg->exec();
	repaint();
}

/**  */
void KCDLabel::slotImageIncreaseOrder()
{
	if (!ObjectSelected) return;
	ObjectSelected->Order++;
	
	switch (CurrentPageToDisplay)
		{
		case BACK_PAGE :
			BackPage.SortImages();
			break;
		case ROUND_PAGE :
			RoundPage.SortImages();
			break;
		default:			
			FrontPages[CurrentPageToDisplay-1].SortImages();
			break;
		}
	AdjustStatus();
	repaint();
}

/**  */
void KCDLabel::slotImageDecreaseOrder()
{
	if (!ObjectSelected) return;
	ObjectSelected->Order--;
	
	switch (CurrentPageToDisplay)
		{
		case BACK_PAGE :
			BackPage.SortImages();
			break;
		case ROUND_PAGE :
			RoundPage.SortImages();
			break;
		default :			
			FrontPages[CurrentPageToDisplay-1].SortImages();
			break;
		}
	AdjustStatus();
	repaint();
}
/** display the about box */
void KCDLabel::slotHelpAbout()
{
	About * myabout = new About(this, i18n("About..."));
	myabout->exec();
}

/** insert a string on a page */
void KCDLabel::slotStringInsert()
{
	StringEditDlg * dlg;
	
	// open the slide edit dialog box
	switch ( CurrentPageToDisplay )
		{
		case BACK_PAGE :
			dlg = new StringEditDlg(this, i18n("Insert a String"), &BackPage, NULL, ClickedPos);
			break;
		case ROUND_PAGE :
			dlg = new StringEditDlg(this, i18n("Insert a String"), &RoundPage, NULL, ClickedPos);
			break;
		default :
			dlg = new StringEditDlg(this, i18n("Insert a String"), &FrontPages[CurrentPageToDisplay-1], NULL, ClickedPos);
			break;
		}
	
	dlg->exec();
	repaint();
}

/** delete selected string */
void KCDLabel::slotObjectDelete()
{
	if (ObjectSelected)
		{
		// if object is referenced in our clipboard
		
		// delete the object on the page
		switch (CurrentPageToDisplay)
			{
			case BACK_PAGE :
				BackPage.DeleteSelectedObject(ObjectSelected);
				break;
			case ROUND_PAGE :
				RoundPage.DeleteSelectedObject(ObjectSelected);
				break;
			default :
				FrontPages[CurrentPageToDisplay-1].DeleteSelectedObject(ObjectSelected);
				break;
			}			
		ObjectSelected = NULL;
		}
	EnableComponents();
	AdjustStatus();
	repaint();
}

/** modify the selected string */
void KCDLabel::slotStringModify()
{
	if (ObjectSelected==NULL)
		return;
	if ( ObjectSelected->GetClassType()!=TYPE_CLASS_STRING
	     && ObjectSelected->GetClassType()!=TYPE_CLASS_CURVED_STRING
	     && ObjectSelected->GetClassType()!=TYPE_CLASS_MULTI_STRING )
		return;
	
	StringEditDlg * dlg;
	StringMultiLineDlg * dlg2;
	
	// open the slide edit dialog box
	switch ( ObjectSelected->GetClassType() )
		{
		case TYPE_CLASS_STRING :
			{
			//if (CurrentPageToDisplay==0)
				dlg = new StringEditDlg(this, i18n("Modify a String"), NULL, dynamic_cast<KCoverString *>(ObjectSelected), ClickedPos);
			//else
			//	dlg = new StringEditDlg(this, i18n("Modify a String"), NULL, dynamic_cast<KCoverString *>(ObjectSelected), ClickedPos);
			dlg->exec();
			} break;
		case TYPE_CLASS_CURVED_STRING :
			{
			//if (CurrentPageToDisplay==0)
				dlg = new StringCurvedEdit(this, i18n("Modify a Curved String"), NULL, dynamic_cast<KCoverCurvedString *>(ObjectSelected), ClickedPos);
			//else
			//	dlg = new StringCurvedEdit(this, i18n("Modify a Curved String"), NULL, dynamic_cast<KCoverCurvedString *>(ObjectSelected), ClickedPos);
			dlg->exec();
			} break;
		case TYPE_CLASS_MULTI_STRING :
			{
			//if (CurrentPageToDisplay==0)
				dlg2 = new StringMultiLineDlg(this, i18n("Modify a Curved String"), NULL, dynamic_cast<KCoverMultiString *>(ObjectSelected), ClickedPos);
			//else
			//	dlg2 = new StringMultiLineDlg(this, i18n("Modify a Curved String"), NULL, dynamic_cast<KCoverMultiString *>(ObjectSelected), ClickedPos);
			dlg2->exec();
			} break;
		}
	repaint();		
}

/**  */
void KCDLabel::slotStringIncreaseOrder()
{
	if (!ObjectSelected) return;
	ObjectSelected->Order++;
	
	switch (CurrentPageToDisplay)
		{
		case BACK_PAGE :
			BackPage.SortStrings();
			break;
		case ROUND_PAGE :
			RoundPage.SortStrings();
			break;
		default :
			FrontPages[CurrentPageToDisplay-1].SortStrings();
			break;
		}
	AdjustStatus();
	repaint();
}

/**  */
void KCDLabel::slotStringDecreaseOrder()
{
	if (!ObjectSelected) return;
	ObjectSelected->Order--;
	
	switch (CurrentPageToDisplay)
		{
		case BACK_PAGE :
			BackPage.SortStrings();
			break;
		case ROUND_PAGE :
			RoundPage.SortStrings();
			break;
		default :
			FrontPages[CurrentPageToDisplay-1].SortStrings();
			break;
		}
	AdjustStatus();
	repaint();
}

/** Enable/disable some controls according to the selection */
void KCDLabel::EnableComponents()
{
	// Disable/enable string entries
	stringmenu->setItemEnabled( STRING_MENU_DELETE, ObjectSelected && ( ObjectSelected->GetClassType()==TYPE_CLASS_STRING
			|| ObjectSelected->GetClassType()==TYPE_CLASS_CURVED_STRING || ObjectSelected->GetClassType()==TYPE_CLASS_MULTI_STRING ) );
	stringmenu->setItemEnabled( STRING_MENU_MODIFY, ObjectSelected && ( ObjectSelected->GetClassType()==TYPE_CLASS_STRING
			|| ObjectSelected->GetClassType()==TYPE_CLASS_CURVED_STRING || ObjectSelected->GetClassType()==TYPE_CLASS_MULTI_STRING ) );	
	stringmenu->setItemEnabled( STRING_MENU_ORDER, ObjectSelected && ( ObjectSelected->GetClassType()==TYPE_CLASS_STRING
			|| ObjectSelected->GetClassType()==TYPE_CLASS_CURVED_STRING || ObjectSelected->GetClassType()==TYPE_CLASS_MULTI_STRING ) );
				
	// Disable/enable images entries
	imagemenu->setItemEnabled( IMAGE_MENU_DELETE, ObjectSelected && ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE );
	imagemenu->setItemEnabled( IMAGE_MENU_RESIZEFULL, ObjectSelected && ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE );
	imagemenu->setItemEnabled( IMAGE_MENU_RESIZE, ObjectSelected && ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE );
	imagemenu->setItemEnabled( IMAGE_MENU_ALIGN, ObjectSelected && ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE );
	imagemenu->setItemEnabled( IMAGE_MENU_ORDER, ObjectSelected && ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE );
	imagemenu->setItemEnabled( IMAGE_MENU_TILED, ObjectSelected && ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE );
	imagemenu->setItemEnabled( IMAGE_MENU_TRANSPARENCY, ObjectSelected && ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE );
	
	// Disable/enable edit entries
	editmenu->setItemEnabled( EDIT_MENU_CUT, ObjectSelected );
	editmenu->setItemEnabled( EDIT_MENU_COPY, ObjectSelected );
	editmenu->setItemEnabled( EDIT_MENU_PASTE, myClipboard.GetStoredObjectType()!=ACTIVE_OBJ_NONE );

        // Disable/enable file entries
        bool coverToBeSaved             = CoverToBeSaved();
        bool coverToBePrinted           = CoverToBePrinted();
        bool roundPageToBePrinted       = RoundPageToBePrinted();

        filemenu->setItemEnabled( FILE_MENU_SAVE, coverToBeSaved );
        filemenu->setItemEnabled( FILE_MENU_PRINTBOOK, coverToBePrinted );
        filemenu->setItemEnabled( FILE_MENU_PRINTROUND, roundPageToBePrinted );
	
	// Disable/enable page entries
	pagemenu->setItemEnabled( PAGE_MENU_ALIGN, ObjectSelected );

        // Disable/enable toolbar buttons
        toolBar()->setItemEnabled ( FILE_SAVE, coverToBeSaved );
        toolBar()->setItemEnabled ( FILE_PRINT, roundPageToBePrinted || coverToBePrinted );
        toolBar()->setItemEnabled ( OBJECT_DELETE, ObjectSelected );

        // check misc things...
        slidemenu->setItemChecked( SLIDE_BACKGROUND, BackPage.SlideTransparentBackground );
	
}

/** select the source dircetory to read from */
void KCDLabel::slotBodySelectSource()
{
	SourceSelectDlg * dlg = new SourceSelectDlg(this, "Source Directory",  TheBody->SourceCD);
	dlg->exec();
	repaint();
}

/** set the number of columns to display */
void KCDLabel::slotNumberColumn(int id)
{
	columnmenu->setItemChecked(TheBody->Columns, false);
	TheBody->Columns = id - COLUMN_0;
	columnmenu->setItemChecked(TheBody->Columns, true);	
	repaint();
}

/** fix the number of levels to scan */
void KCDLabel::slotNumberLevel(int id)
{
	levelmenu->setItemChecked( TheBody->Levels, false );
	TheBody->Levels = id;
	levelmenu->setItemChecked( TheBody->Levels, true );
	TheBody->BuildResultTree();
	repaint();
}

/** select font to use for body */
void KCDLabel::slotBodySelectFont()
{
     KFontDialog fontdlg(this, i18n("Select Font"), false, true);
     fontdlg.setFont(*TheBody->BodyFont->Font);
     int result = fontdlg.exec();
     if ( result == KFontDialog::Accepted )
		{
		if (TheBody->BodyFont->Font)
			delete TheBody->BodyFont->Font;
		TheBody->BodyFont->Font = new QFont( fontdlg.font() );
		repaint();
		}
}

/** user select line or not */
void KCDLabel::slotBodyLined(int id)
{
	if (id==BODY_LINE)
		{
		TheBody->BodyLined = !TheBody->BodyLined;
		bodymenu->setItemChecked(BODY_LINE, TheBody->BodyLined );
		repaint();
		}
	
}
/** user select to draw or not the tree lines */
void KCDLabel::slotBodyDrawTree(int id)
{
	if (id==TREE_LINE)
		{
		TheBody->BodyTreeLine = !TheBody->BodyTreeLine;
		bodymenu->setItemChecked( TREE_LINE, TheBody->BodyTreeLine );
		repaint();
		}
}
/** enable page number display */
void KCDLabel::slotBodyPageNumber(int id)
{
	if (id==DISPLAY_PAGENUMBER)
		{
		TheBody->DisplayPageNumber = !TheBody->DisplayPageNumber;
		bodymenu->setItemChecked( DISPLAY_PAGENUMBER, TheBody->DisplayPageNumber);
		repaint();
		}
}

/** display body layout dialog */
void KCDLabel::slotBodyLayout()
{
	BodyLayout * dlg = new BodyLayout(this, i18n("Choose body layout"), &TheBody->BodyPage);
	dlg->exec();
	repaint();
}

/** invoke the help manual */
void KCDLabel::slotHelpManual()
{
	kapp->invokeHTMLHelp("kcdlabel/index.html", "");
}

/** display the correct status info according to selected object */
void KCDLabel::AdjustStatus()
{
	char buf[100];
	
	if ( ObjectSelected )
		sprintf(buf, i18n("Select.Obj. : Pos=(%d,%d), Size=(%d,%d), Order=%d"), ObjectSelected->X, ObjectSelected->Y, ObjectSelected->Width(), ObjectSelected->Height(), ObjectSelected->Order );
	else
		buf[0]=0;		
	
	statusbar->changeItem(buf, STATUS_MSG);
}

/** insert a line of text on a circle */
void KCDLabel::slotStringInsertCurved()
{
	StringCurvedEdit * dlg;
	
	// open the slide edit dialog box
	switch (CurrentPageToDisplay)
		{
		case BACK_PAGE :
			dlg = new StringCurvedEdit(this, i18n("Insert a Curved String"), &BackPage, NULL, ClickedPos);
			break;
		case ROUND_PAGE :
			dlg = new StringCurvedEdit(this, i18n("Insert a Curved String"), &RoundPage, NULL, ClickedPos);
			break;
		default :
			dlg = new StringCurvedEdit(this, i18n("Insert a Curved String"), &FrontPages[CurrentPageToDisplay-1], NULL, ClickedPos);
			break;			
		}
	
	dlg->exec();
	repaint();
}

/** insert a multi line of text */
void KCDLabel::slotStringInsertMulti()
{
	StringMultiLineDlg * dlg;
	
	// open the slide edit dialog box
	switch (CurrentPageToDisplay)
		{
		case BACK_PAGE :
			dlg = new StringMultiLineDlg(this, i18n("Insert a Multi String"), &BackPage, NULL, ClickedPos);
			break;
		case ROUND_PAGE :
			dlg = new StringMultiLineDlg(this, i18n("Insert a Multi String"), &RoundPage, NULL, ClickedPos);
			break;
		
		default :
			dlg = new StringMultiLineDlg(this, i18n("Insert a Multi String"), &FrontPages[CurrentPageToDisplay-1], NULL, ClickedPos);
			break;
		}
	dlg->exec();
	repaint();
}

void KCDLabel::slotStringMultiIncreaseOrder()
{
	if (!ObjectSelected) return;
	ObjectSelected->Order++;
	
	switch (CurrentPageToDisplay)
		{
		case BACK_PAGE :
			BackPage.SortMultiStrings();
			break;
		case ROUND_PAGE :
			RoundPage.SortMultiStrings();
			break;
		default:
			FrontPages[CurrentPageToDisplay-1].SortMultiStrings();
			break;
		}
	AdjustStatus();
	repaint();
}

void KCDLabel::slotStringMultiDecreaseOrder()
{
	if (!ObjectSelected) return;
	ObjectSelected->Order--;
	
	switch (CurrentPageToDisplay)
		{
		case BACK_PAGE :
			BackPage.SortMultiStrings();
			break;
		case ROUND_PAGE :
			RoundPage.SortMultiStrings();
			break;
		default :
			FrontPages[CurrentPageToDisplay-1].SortMultiStrings();
			break;
		}
	AdjustStatus();
	repaint();
}

/** set the image to be drawn tiled */
void KCDLabel::slotImageTiled()
{
    if ( ObjectSelected!=NULL )
    	if ( ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE )
    		{
    		KCoverImage * ImageSelected = dynamic_cast<KCoverImage *>(ObjectSelected);
			ImageSelected->ToggleTiled();
			repaint();
			imagemenu->setItemChecked( IMAGE_MENU_TILED, ImageSelected->DrawTiled );
			ImagePopupMenu->setItemChecked( IMAGE_MENU_TILED, ImageSelected->DrawTiled );
			}
}

/** transparency of not */
void KCDLabel::slotImageTransparency()
{
    if ( ObjectSelected!=NULL )
    	if ( ObjectSelected->GetClassType()==TYPE_CLASS_IMAGE )
    		{
    		KCoverImage * ImageSelected = dynamic_cast<KCoverImage *>(ObjectSelected);
				ImageSelected->ToggleTransparency();
				repaint();
				imagemenu->setItemChecked( IMAGE_MENU_TRANSPARENCY, ImageSelected->KeepTransparency );
				ImagePopupMenu->setItemChecked( IMAGE_MENU_TRANSPARENCY, ImageSelected->KeepTransparency );
				}
}
/** user press a tool bar button */
void KCDLabel::slotToolBarClick(int id)
{
	switch ( id )
		{
		case FILE_NEW :
			slotFileNew();
			break;
		case FILE_LOAD :
			slotFileOpen();
			break;
		case FILE_SAVE :
			slotFileSave();
			break;
		case FILE_PRINT :
			slotFilePrint();
			break;
		case OBJECT_DELETE :
			slotObjectDelete();
			repaint();
			break;
		case OBJECT_IMAGE :
			slotImageInsert();
			break;
		case OBJECT_TEXT :
			slotStringInsert();
			break;
		case OBJECT_MULTI_TEXT :
			slotStringInsertMulti();
			break;
		case OBJECT_CURVED_TEXT :
			slotStringInsertCurved();
			break;
		}
}
/** user move the toolbar */
void KCDLabel::slotToolBarMoved()
{
	repaint();
}

/** adjust the body menu settings */
void KCDLabel::AdjustBodyMenuParameters()
{
	bodymenu->setItemChecked( BODY_LINE, TheBody->BodyLined );
	bodymenu->setItemChecked( TREE_LINE, TheBody->BodyTreeLine );
	bodymenu->setItemChecked( DISPLAY_PAGENUMBER, TheBody->DisplayPageNumber);
	columnmenu->setItemChecked(TheBody->Columns, true);	
	levelmenu->setItemChecked( TheBody->Levels, true );
}
/** open the greeting dialog */
void KCDLabel::slotHelpThanks()
{
	ThanksDlg * dlg = new ThanksDlg;
	dlg->exec();
}

void KCDLabel::slotPageColor()
{
	KCoverBackground * back;
	
	switch ( CurrentPageToDisplay )
		{
		case BACK_PAGE :
			back = &(BackPage.Background);
			break;
		case ROUND_PAGE :
			back = &(RoundPage.RoundBackground);
			break;
		default :
			back = &(FrontPages[CurrentPageToDisplay-1].Background);
			break;
		}
	
	BackgroundDialog * dlg = new BackgroundDialog( back );
	dlg->exec();
	
	repaint();
}

/** align selected object on the page */
void KCDLabel::slotPageAlignObject()
{
    /*AlignType*/int halign=None;
    /*AlignType*/int valign=None;
	
	AlignDlg * dlg = new AlignDlg( &halign, &valign );
	dlg->exec();
	
	if ( ObjectSelected!=NULL )
		{
		switch ( CurrentPageToDisplay )
			{
			case BACK_PAGE :
				ObjectSelected->Align(BackPage, halign, valign );
				break;
			case ROUND_PAGE :
				ObjectSelected->Align(RoundPage, halign, valign );
				break;
			default :
				ObjectSelected->Align(FrontPages[CurrentPageToDisplay-1], halign, valign );
				break;
			}
		repaint();
		}
}

void KCDLabel::slotCut()
{
	slotCopy();
	slotObjectDelete();
}

void KCDLabel::slotCopy()
{
	myClipboard.Clean();
	if ( ObjectSelected!=NULL )
		switch ( ObjectSelected->GetClassType() )
			{
			case TYPE_CLASS_IMAGE :
				myClipboard.Store( dynamic_cast<KCoverImage *>(ObjectSelected) );
				break;
			case TYPE_CLASS_STRING :
				myClipboard.Store( dynamic_cast<KCoverString *>(ObjectSelected) );
				break;
			case TYPE_CLASS_CURVED_STRING :
				myClipboard.Store( dynamic_cast<KCoverCurvedString *>(ObjectSelected) );
				break;
			case TYPE_CLASS_MULTI_STRING :
				myClipboard.Store( dynamic_cast<KCoverMultiString *>(ObjectSelected) );
				break;
			}
}

void KCDLabel::slotPaste()
{
	if ( myClipboard.GetStoredObjectType()!=ACTIVE_OBJ_NONE )
		{
		switch ( CurrentPageToDisplay )
			{
			case BACK_PAGE :
				{
				switch ( myClipboard.GetStoredObjectType() )
					{
					case TYPE_CLASS_IMAGE :
						{
						KCoverImage * img = new KCoverImage( myClipboard.RetrieveImage() );
						BackPage.AddImage( img );
						}
						break;
					case TYPE_CLASS_STRING :
						{
						KCoverString *tmp = new KCoverString( myClipboard.RetrieveString() );
						BackPage.AddString( tmp  );
						}
						break;
					case TYPE_CLASS_CURVED_STRING :
						{
						KCoverCurvedString *tmp = new KCoverCurvedString( myClipboard.RetrieveCurvedString() );
						BackPage.AddCurvedString( tmp );
						}
						break;
					case TYPE_CLASS_MULTI_STRING :
						{
					    KCoverMultiString *tmp = new KCoverMultiString( myClipboard.RetrieveMultiString() );
						BackPage.AddMultiString( tmp );
						}
						break;
					}
				}
				break;				
			case ROUND_PAGE :
				{
				switch ( myClipboard.GetStoredObjectType() )
					{
					case TYPE_CLASS_IMAGE :
						{
						KCoverImage * img = new KCoverImage( myClipboard.RetrieveImage() );
						RoundPage.AddImage( img );
						}
						break;
					case TYPE_CLASS_STRING :
						{
						KCoverString * tmp = new KCoverString( myClipboard.RetrieveString() );
						RoundPage.AddString( tmp );
						}
						break;
					case TYPE_CLASS_CURVED_STRING :
						{
						KCoverCurvedString *tmp = new KCoverCurvedString( myClipboard.RetrieveCurvedString() );
						RoundPage.AddCurvedString( tmp );
						}
						break;
					case TYPE_CLASS_MULTI_STRING :
						{
						KCoverMultiString *tmp = new KCoverMultiString( myClipboard.RetrieveMultiString() );
						RoundPage.AddMultiString( tmp );
						}
						break;
					}
				}
				break;				
			default :
				{
				switch ( myClipboard.GetStoredObjectType() )
					{
					case TYPE_CLASS_IMAGE :
						{
						KCoverImage * img = new KCoverImage( myClipboard.RetrieveImage() );
						FrontPages[CurrentPageToDisplay-1].AddImage( img );
						}
						break;
					case TYPE_CLASS_STRING :
						{
						KCoverString * tmp = new KCoverString( myClipboard.RetrieveString() );
						FrontPages[CurrentPageToDisplay-1].AddString( tmp );
						}
						break;
					case TYPE_CLASS_CURVED_STRING :
						{
						KCoverCurvedString *tmp = new KCoverCurvedString( myClipboard.RetrieveCurvedString() );
						FrontPages[CurrentPageToDisplay-1].AddCurvedString( tmp );
						}
						break;
					case TYPE_CLASS_MULTI_STRING :
						{
						KCoverMultiString *tmp = new KCoverMultiString( myClipboard.RetrieveMultiString() );
						FrontPages[CurrentPageToDisplay-1].AddMultiString( tmp );
						}
						break;
					}
				}
				break;				
			}
		repaint();
		}
}

/** access to cddb server */
void KCDLabel::CDDBAccess()
{
	CDDBAccessDialog * cddbdlg = new CDDBAccessDialog(&BackPage, &FrontPages[0], this);
	cddbdlg->exec();
	repaint();
}


/** No descriptions */
unsigned int KCDLabel::GetNumberOfPagesToPrint(unsigned int page)
{
    unsigned int nb=0;
    for ( unsigned int i=page; i<MAX_PAGES;i++ )
	if ( FrontPages[i].NumberOfObjects || FrontPages[i].PageToPrint )
	    nb++;
    return nb;

}


/** return true if the booklet could be saved or printed (if there are valid pages) */
bool KCDLabel::CoverToBeSaved()
{
    if ( GetNumberOfPagesToPrint(0) || BackPage.NumberOfObjects || BackPage.PageToPrint || RoundPageToBePrinted() )
	return true;
        else
	    return false;
}

/** return true if the round page has to be printed */
bool KCDLabel::RoundPageToBePrinted()
{
    if ( RoundPage.NumberOfObjects || RoundPage.PageToPrint )
	return true;
        else
	    return false;
}
/** return true if the cover is valid to be printed */
bool KCDLabel::CoverToBePrinted()
{
    if ( GetNumberOfPagesToPrint(0) || BackPage.NumberOfObjects || BackPage.PageToPrint )
	return true;
        else
	    return false;

}
