/***************************************************************************
                          koverobject.cpp  -  description
                             -------------------
    begin                : Sun Apr 16 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcoverobject.h>
#include <kcoverpage.h>

/** used for sorting on "Order" field */
bool KCoverObject::operator < (KCoverObject &p)
{
	return (Order < p.Order);
}

/** save object */
void KCoverObject::Save(QFile &file)
{	
	// save the coordinates and the order
	file.writeBlock( (char *)&X, sizeof(int) );
	file.writeBlock( (char *)&Y, sizeof(int) );
	file.writeBlock( (char *)&Order, sizeof(int) );
	file.writeBlock( (char *)&IsMovable, sizeof(bool) );
}

/** load an object */
void KCoverObject::Load(QFile &file, int )
{
	// load the coordinates and the order
	file.readBlock( (char *)&X, sizeof(int) );
	file.readBlock( (char *)&Y, sizeof(int) );
	file.readBlock( (char *)&Order, sizeof(int) );
	file.readBlock( (char *)&IsMovable, sizeof(bool) );
}

/** align an object on a page */
void KCoverObject::Align(KCoverPage & page, const int halign, const int valign)
{
//	page.AlignObject( X, Y, Width(), Height(), halign, valign, GetTopAlignDelta(), GetBottomAlignDelta(), GetClassType() );
	page.AlignObject( this, halign, valign );
}

/** give a value to suibstract or add it pixels for alignement problems related to some objects like texts */
const int KCoverObject::GetTopAlignDelta()
{
	return 0;
}

/** give a value to substract or add it pixels for alignement problems related to some objects like texts */
const int KCoverObject::GetBottomAlignDelta()
{
	return 0;
}

/** give a value to substract or add it pixels for alignement problems related to some objects like texts */
const int KCoverObject::GetMiddleAlignDelta()
{
	return 0;
}
