/***************************************************************************
                          kroundcoverbackground.cpp  -  description
                             -------------------
    begin                : Mon Apr 16 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kroundcoverbackground.h"
#include <kpixmap.h>
#include <id.h>

KRoundCoverBackground::KRoundCoverBackground(QColor c1, QColor c2)
: KCoverBackground(c1, c2)
{
}


void KRoundCoverBackground::Paint( QPainter *paint, QPoint orig, int W, int H )
{
	KPixmap pix;
	pix.resize( W, H );
	QPixmap * bufferpixmap=NULL;
	QPainter * currentpaint=NULL;
	QPoint savedorig = orig;
	bool PrinterActivated = false;
	bool deletepaint = true;
	
	if ( UseFlatMode )
		{
		// save current pen
		QPen saved_pen = paint->pen();
		// draw a filled rectangle
		paint->setPen( Qt::NoPen );
		paint->setBrush( Color1 );
		paint->drawEllipse( orig.x(), orig.y(), ROUND_BIG, ROUND_BIG );
		paint->setBrush( Qt::white );
		paint->drawEllipse( orig.x()+(ROUND_BIG/2)-(ROUND_SMALL/2), orig.y()+(ROUND_BIG/2)-(ROUND_SMALL/2), ROUND_SMALL, ROUND_SMALL );
		// restore brush and pen
		paint->setPen( saved_pen );
		}
	else
		{
		if ( paint->device()->devType()==QInternal::Printer )
			{
			PrinterActivated = true;
			bufferpixmap = new QPixmap;
			bufferpixmap->resize( W, H );
			bufferpixmap->fill( Qt::white );
			currentpaint = new QPainter( bufferpixmap );
			orig = QPoint(0,0);
			}
		else
			{
			currentpaint = /*&*/paint;
			deletepaint = false;
			}
		
		// create the gradient
		KPixmapEffect::gradient( pix, Color1, Color2, Mode );
		// map the pixmap into the QPainter
		
 		// save the current raster operation from the painter
		Qt::RasterOp savedROP = paint->rasterOp();
		QBrush savedBrush = paint->brush();
   		// draw a filled black rectangle around the circle + an inner black circle
   		currentpaint->setPen( Qt::black );
	  	currentpaint->setBrush( Qt::black );
  		currentpaint->drawRect( orig.x(), orig.y(), ROUND_BIG, ROUND_BIG );
		currentpaint->setBrush( Qt::white );  			
  		currentpaint->drawEllipse( orig.x(), orig.y(), ROUND_BIG, ROUND_BIG );
  		currentpaint->setBrush( Qt::black );
		currentpaint->drawEllipse( orig.x()+(ROUND_BIG/2)-(ROUND_SMALL/2), orig.y()+(ROUND_BIG/2)-(ROUND_SMALL/2), ROUND_SMALL, ROUND_SMALL );
		// set raster operation to And
		currentpaint->setRasterOp( Qt::AndROP );
		// draw the pixmap
		currentpaint->drawPixmap( orig, pix );
		// erase the black corner
		currentpaint->setRasterOp( Qt::XorROP );
		// mask the rectangle's borders
		currentpaint->setBrush( Qt::white );
		currentpaint->setPen( Qt::white );
		currentpaint->drawRect( orig.x(), orig.y(), W, H );
		currentpaint->drawEllipse( orig.x(), orig.y(), ROUND_BIG, ROUND_BIG );
		currentpaint->drawEllipse( orig.x()+(ROUND_BIG/2)-(ROUND_SMALL/2), orig.y()+(ROUND_BIG/2)-(ROUND_SMALL/2), ROUND_SMALL, ROUND_SMALL );			
   		// reset the saved raster operation on the painter
		currentpaint->setRasterOp( savedROP );
		currentpaint->setBrush( savedBrush );
		
		if (PrinterActivated )
			paint->drawPixmap( savedorig.x(), savedorig.y(), *bufferpixmap);
		
		// destroy dynamic objects
		if ( bufferpixmap )
			delete bufferpixmap;
		//if ( currentpaint && deletepaint)
		//	delete currentpaint;
		
		}
}
