/***************************************************************************
                          qscrollframe.cpp  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

#include "qscrollframe.h"
#include <math.h>
#include <stdio.h>

QScrollFrame::QScrollFrame(QWidget * parent, const char * name, WFlags f, bool allowLines)
 : QFrame(parent, name, f)
{
	int w = 2*frameWidth();
	buffer.resize( width() - w, height() - w );
	tempbuf.resize( width() - w, height() - w );
	PosY = -999999;		// dummy position
	QObject::connect(&Clock, SIGNAL(timeout()), this, SLOT(ElapsedTime()) );
	Line = 0;
	Scrolling = false;
	MaxLines = 0;
	Interval = 50; 	// +/- 50 msecs interval between each refresh
	Background = QColor(black);
	NewLine = true;
	defaultColor = QColor(white);
	defaultFont = QFont("helvetica");
	Text = NULL;
}

/*QScrollFrame::~QScrollFrame()
{
}*/

void QScrollFrame::setScrollText( char ** txt, int n )
{
	Text = txt;
	MaxLines = n;
}

/** specify the interval in milliseconds */
void QScrollFrame::setInterval(int msecs)
{
	Interval = msecs;
}

/** start the scroller */
void QScrollFrame::start()
{
	Scrolling = true;
	Clock.start( Interval, true );
}

/** stop the scroller */
void QScrollFrame::stop()
{
	Clock.stop();
	Scrolling = false;
}

/** draw content of the frame */
void QScrollFrame::drawContents( QPainter * paint)
{
	if (Text==NULL)
		return;
		
	QFontMetrics fm(defaultFont); //paint->fontMetrics();
	tempbuf.fill( Background );
		
	int r,g,b;
	QString buf= QString(Text[Line]);
	bool MatchColor = false;
	
	if ( sscanf(Text[Line],"[%d,%d,%d]", &r, &g, &b ) == 3 )
		{
		char * p = strchr(Text[Line],']');
		buf = QString(p+1);
		MatchColor = true;
		}
	
	int textHeight = (fm.boundingRect((const char *) buf )).height();
	int textWidth  = (fm.boundingRect((const char *) buf )).width() + 5;
	if ( strlen(Text[Line]) == 0 )
		{
		textHeight = (fm.boundingRect("W")).height();
		textWidth  = (fm.boundingRect("W")).width()+5;
		}
	
	if ( NewLine )
		{
		PosY = tempbuf.height()-2*frameWidth();
		//bitBlt( &tempbuf, 0, 0, &buffer, 0, 1, tempbuf.width, -1 );
		Remains = textHeight+5;
		NewLine = false;
		}
		
	int re = tempbuf.height() - ( textHeight - Remains ) - 1;
	bitBlt( &tempbuf, 0, 0, &buffer, 0, 1, tempbuf.width(), re );
	
	// draw the current text
	PosX = ( width()-2*frameWidth()-fm.width( (const char * )buf ))/2;
	paint->setFont(defaultFont);
	paint->setClipping(false);
	if (MatchColor)
		paint->setPen( QColor(r,g,b) );
	else
		paint->setPen( defaultColor );
	paint->drawText( PosX, PosY, textWidth, textHeight, AlignBottom|DontClip, (const char *) buf );
	
	Remains--;
	PosY--;
	
	if ( Remains==0 )
		{
		NewLine=true;
		Line++;
		if (Line>=MaxLines )
			Line = 0;
		}
		
	bitBlt( &buffer, 0, 0, &tempbuf, 0, 0, tempbuf.width(), tempbuf.height() );
}

/** resize event */
void QScrollFrame::resizeEvent ( QResizeEvent * ev)
{
	QFrame::resizeEvent(ev);
	int w = 2*frameWidth();	
	buffer.resize( width()-w, height()-w );
	buffer.fill( Background );
	tempbuf.resize( width()-w, height()-w );		
	repaint(false);
}

void QScrollFrame::paintEvent( QPaintEvent * event )
{
	//QFrame::paintEvent(event);
	QPainter paint(&tempbuf);
	drawContents( &paint );
    bitBlt(this, event->rect().topLeft().x()+frameWidth(), event->rect().topLeft().y()+frameWidth(),  &buffer, 0, 0, buffer.width(), buffer.height() );
    Clock.start( Interval, true);
}

void QScrollFrame::ElapsedTime()
{
	repaint(false);		// false --> doesn't erase the background before retracing to avoid flickering
}

