/***************************************************************************
                          aligndlg.cpp  -  description
                             -------------------
    begin                : Sat Apr 28 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "aligndlg.h"

AlignDlg::AlignDlg( int * halign, int *valign, QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();
	
	// define some interface tricks
	QButtonGroup_1->insert(TopRadio,0);
	QButtonGroup_1->insert(CenterVRadio,1);
	QButtonGroup_1->insert(BottomRadio,2);
	QButtonGroup_1->insert(NoneVRadio,3);
	
	QButtonGroup_2->insert(LeftRadio,0);
	QButtonGroup_2->insert(CenterHRadio,1);
	QButtonGroup_2->insert(RightRadio,2);
	QButtonGroup_2->insert(NoneHRadio,3);
	
	// keep some references...
	Halign = halign;
	Valign = valign;

	// setup signals and slots
	QObject::connect(OkButton, SIGNAL(clicked()), this, SLOT(accept()) );
	QObject::connect(CancelButton, SIGNAL(clicked()), this, SLOT(reject()) );
	QObject::connect(QButtonGroup_1, SIGNAL(clicked(int)), this, SLOT(VerticalButtonSelected(int)) );
	QObject::connect(QButtonGroup_2, SIGNAL(clicked(int)), this, SLOT(HorizontalButtonSelected(int)) );	
}

AlignDlg::~AlignDlg()
{
}

void AlignDlg::VerticalButtonSelected(int id)
{
	switch (id)
		{
		case 0 :
			*Valign = Top;
			break;
		case 1 :
			*Valign = Center;
			break;
		case 2 :
			*Valign = Bottom;
			break;
		case 3 :
			*Valign = None;
			break;
		}
}

void AlignDlg::HorizontalButtonSelected(int id)
{
	switch (id)
		{
		case 0 :
			*Halign = Left;
			break;
		case 1 :
			*Halign = Center;
			break;
		case 2 :
			*Halign = Right;
			break;
		case 3 :
			*Halign = None;
			break;
		}
}

