/***************************************************************************
                          kcoverobjectcontainer.h  -  description
                             -------------------
    begin                : Tue May 1 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVEROBJECTCONTAINER_H
#define KCOVEROBJECTCONTAINER_H

#include <kcoverobject.h>
#include <kcoverimage.h>
#include <kcoverstring.h>
#include <kcovermultistring.h>
#include <kcovercurvedstring.h>
#include <kcoverpage.h>

#define ACTIVE_OBJ_NONE				0
#define ACTIVE_OBJ_IMAGE			TYPE_CLASS_IMAGE
#define ACTIVE_OBJ_STRING			TYPE_CLASS_STRING
#define ACTIVE_OBJ_MULTISTRING		TYPE_CLASS_MULTI_STRING
#define ACTIVE_OBJ_CURVEDSTRING		TYPE_CLASS_CURVED_STRING

/**hold objects to provide operations like Copy-Paste-Delete-Undo-Redo...
  *@author Pascal 'PeP' Panneels
  */

class KCoverObjectContainer
{
public: 
	KCoverObjectContainer();
	//~KCoverObjectContainer();
	/** clean the container */
	void Clean();
	/** store an object in the container */
	void Store( KCoverImage *obj );
	void Store( KCoverString *obj );	
	void Store( KCoverMultiString *obj );
	void Store( KCoverCurvedString *obj );
	/** retrieve the stored object */
	KCoverImage RetrieveImage();
	KCoverString RetrieveString();
	KCoverMultiString RetrieveMultiString();
	KCoverCurvedString RetrieveCurvedString();
	char GetStoredObjectType()
	    { return SavedObjectType; }
	
	
protected :
	// pointers to enable tracking of objects
	// these objects will be copied here.
	KCoverImage			SavedImage;
	KCoverString 		SavedString;
	KCoverMultiString	SavedMultiString;
	KCoverCurvedString	SavedCurvedString;
	/** type of saved object */
	char SavedObjectType;
	
};

#endif
