/***************************************************************************
                          kcoverroundpage.h  -  description
                             -------------------
    begin                : Tue Mar 27 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVERROUNDPAGE_H
#define KCOVERROUNDPAGE_H

#include <kcoverpage.h>
#include <qpainter.h>
#include <qpoint.h>
#include <kroundcoverbackground.h>

/**draw round frame to print on cd labels
  *@author Pascal 'PeP' Panneels
  */

class KCoverRoundPage : public KCoverPage  {
public: 
	KCoverRoundPage();
	//virtual ~KCoverRoundPage();
	
	/** draw the frame border (page bordrer) */
	virtual void DrawLayout(QPainter *paint, QPoint orig);
	virtual void DrawImages(QPainter *paint, QPoint orig);
	virtual bool IsPointInPage(QPoint ClickedPos);
	virtual bool Save(QFile &file, int);
	virtual void Load(QFile &file, int version);
	virtual void Clear();
	/** return the page width in pixels */
  	virtual const unsigned int GetPageWidth() const;
  	/** return the page height in pixels */
  	virtual const unsigned int GetPageHeight() const;
  	/** return the page left margin position */
  	virtual const unsigned int GetPageLeftMargin() const;
  	/** return the page right margin position */
  	virtual const unsigned int GetPageRightMargin() const;
	
public :
	bool DrawBorder;
	bool DrawTiledBackgroundImage;
	KRoundCoverBackground RoundBackground;

protected :
	int r, R, rr, RR;
};

#endif

