/***************************************************************************
                          scaleimagedlg.cpp  -  description
                             -------------------
    begin                : Thu Apr 27 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "scaleimagedlg.h"

ScaleImageDlg::ScaleImageDlg(QWidget *parent, const char *name, KCoverImage *img)
 : QDialog(parent,name,true)
{
	initDialog();
	TheImage = img;
	char buf[20];
	sprintf(buf,"%d", InitialW = TheImage->Image.width() );
	Wedit->setText(buf);
	sprintf(buf,"%d", InitialH = TheImage->Image.height() );	
	Hedit->setText(buf);
	
	// create some controls
	scaletype->insert( absolute, 1 );
	scaletype->insert( relative, 2 );	
	scaletype->setButton( Type=1 )	;
	
	// connect some signals to slots	
	QObject::connect(scaletype, SIGNAL(clicked(int)), this, SLOT(slotRadioClicked(int)));
	QObject::connect(OkButton, SIGNAL(clicked()), this, SLOT(CmOk()));
	QObject::connect(CancelButton, SIGNAL(clicked()), this, SLOT(reject()));
    QObject::connect(samecheck, SIGNAL(clicked()), this, SLOT(CmSame()));
    QObject::connect(Wedit, SIGNAL(textChanged(const QString &)), this, SLOT(slotTextChanged(const QString &)));
    setCaption(name);
}

/*ScaleImageDlg::~ScaleImageDlg()
{
}*/

/** user press absolute or relative */
void ScaleImageDlg::slotRadioClicked(int id)
{
	int s;
	char buf[20];
	QString v;
	// absolute ( convert relative to absolute if necessary )
	if ( id==1 )
		{
		if (Type==2)
			{
			Type=1;
			v = QString(Wedit->text());
			s = (int)(v.toFloat() * InitialW) / 100 ;
			sprintf(buf,"%d", s);
			Wedit->setText(buf);
			if (samecheck->isChecked())
				{
				s = (int)( v.toFloat() * InitialH) / 100 ;
				sprintf(buf,"%d", s);
				}
			else
				{
				v = QString(Hedit->text());
				s = (int)( v.toFloat() * InitialH) / 100 ;
				sprintf(buf,"%d", s);
				}
			Hedit->setText(buf);
			}
		}
	else	// relative
		{
		if (Type==1)
			{
			Type=2;
			v = QString(Wedit->text());
			s = (int)(v.toFloat() * 100) / InitialW;
			sprintf(buf,"%d", s);
			Wedit->setText(buf);
			v = QString(Hedit->text());
			s = (int)( v.toFloat() * 100) / InitialH ;
			sprintf(buf,"%d", s);
			Hedit->setText(buf);
			}
		}
}

/** scale the image and finish */
void ScaleImageDlg::CmOk()
{
	QString w(Wedit->text());
	QString h(Hedit->text());
	
	if (Type==1)
		//TheImage->Image = TheImage->Image.smoothScale(w.toInt(), h.toInt());
		TheImage->Scale(w.toInt(), h.toInt());
	else
		//TheImage->Image = TheImage->Image.smoothScale( w.toInt() * InitialW / 100, h.toInt() * InitialH / 100 );
		TheImage->Scale( w.toInt() * InitialW / 100, h.toInt() * InitialH / 100 );
	
	accept();
}

/** same check clicked */
void ScaleImageDlg::CmSame()
{
	Hedit->setEnabled(!samecheck->isChecked());
}

/** adjust the text in the 2 fields */
void ScaleImageDlg::slotTextChanged(const QString &s)
{
	if (samecheck->isChecked())
		Hedit->setText(s);
}
