/***************************************************************************
                          sideeditdlg.cpp  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "sideeditdlg.h"


SideEditDlg::SideEditDlg(QWidget *parent, const char *name, KCoverBack *koverback) : QDialog(parent,name,true)
{
	initDialog();
	Koverback = koverback;	
	// specify some properties
	BackColor->setColor(*(koverback->SideA->backcolor));
	FontColor->setColor(*(koverback->SideA->textcolor));
	SideAText->setText(Koverback->SideA->text().latin1());
	SideBText->setText(Koverback->SideB->text().latin1());
	// connect the necessary signal object to my slots
	QObject::connect(SameCheck, SIGNAL(clicked()), this, SLOT(slotSameChecked()));
	QObject::connect(Ok, SIGNAL(clicked()), this, SLOT(CmOk()));
	QObject::connect(Cancel, SIGNAL(clicked()), this, SLOT(reject()));
	QObject::connect(FontSelect, SIGNAL(clicked()), this, SLOT(slotFontSelect()));
	if (strcmp(Koverback->SideA->text().latin1(),Koverback->SideB->text().latin1()))
		{
		SameCheck->setChecked(false);
		slotSameChecked();
		}
	setCaption(name);
}

/*SideEditDlg::~SideEditDlg()
{
}*/

/** pressing the 'same' check button; we have
to toggle enabling of a label and a edit
control */
void SideEditDlg::slotSameChecked()
{
	QLabel_2->setEnabled(!SameCheck->isChecked());
	SideBText->setEnabled(!SameCheck->isChecked());
}

/** user press ok button  */
void SideEditDlg::CmOk()
{
	Koverback->SideA->SetText( QString(SideAText->text()) );
	if (SameCheck->isChecked())
		Koverback->SideB->SetText( QString(SideAText->text()) );
	else
	    Koverback->SideB->SetText( QString(SideBText->text()) );

	*(Koverback->SideA->textcolor) = QColor(FontColor->color());
	*(Koverback->SideA->backcolor) = QColor(BackColor->color());
	*(Koverback->SideB->textcolor) = QColor(FontColor->color());
	*(Koverback->SideB->backcolor) = QColor(BackColor->color());

	Koverback->PageToPrint = true;

	accept();	// dialog finished ok !
}

/** select the font */
void SideEditDlg::slotFontSelect()
{
	KFontDialog fontdlg(this, i18n("Select Font"), false, true);
	fontdlg.setFont(*Koverback->SideA->Font->Font);
	int result = fontdlg.exec();
	if ( result == KFontDialog::Accepted )
		{
		if (Koverback->SideA->Font->Font)
			delete Koverback->SideA->Font->Font;
		Koverback->SideA->Font->Font = new QFont(fontdlg.font());
	
		if (Koverback->SideB->Font->Font)
			delete Koverback->SideB->Font->Font;
		Koverback->SideB->Font->Font = new QFont(fontdlg.font());	
		}
}
