/***************************************************************************
                         scripttemplate.cpp  -  manage a script template
                         -------------------
    begin                : Sun Jul 27 2003
    copyright            : (C) 2003 by Claudiu Costin
    email                : claudiuc@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qstringlist.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qdom.h>

#include <kdebug.h>
#include <kstddirs.h>

#include "scripttemplate.h"


ScriptPref::RunMode ScriptTemplateItem::runmode() {
  return m_runmode;
}

QString ScriptTemplateItem::title() {
  return m_title;
}

QString ScriptTemplateItem::id() {
  return m_id;
}

QString ScriptTemplateItem::description() {
  return m_description;
}

QString ScriptTemplateItem::outputfile() {
  return m_outputfile;
}

int ScriptTemplateItem::outputfilemode() {
  return m_outputfilemode;
}

QString ScriptTemplateItem::scripttemplate() {
  return m_scripttemplate;
}

QString ScriptTemplateItem::optsep() {
  return m_optsep;
}

QString ScriptTemplateItem::linesep() {
  return m_linesep;
}

KListViewItem* ScriptTemplateItem::li() {
  return m_li;
}

void ScriptTemplateItem::setLi(KListViewItem *item) {
  m_li = item;
}



ScriptTemplate::ScriptTemplate()
{
}

ScriptTemplateItemMap& ScriptTemplate::map()
{
  return m_map;
}

void ScriptTemplate::load(const QString &file)
{
  ScriptPref::RunMode runmode;
  QString id, title, description, outputfile, mode, scripttemplate, optsep, linesep;
  KStandardDirs *dirs = KGlobal::dirs();
  QFile f(file);

  QDomDocument doc(dirs->findResource("data","kcmpureftpdscript/kcmpureftpdscript.dtd"));
  if (f.open(IO_ReadOnly)) {
    if (doc.setContent(&f)) {
      id = title = description = outputfile = QString::null;
      scripttemplate = optsep = linesep = QString::null;
      QDomElement docElem = doc.documentElement();

      QString tmp = docElem.attribute("runmode","standalone");
      if (tmp == "standalone") {
        runmode = ScriptPref::Standalone;
      } else if (tmp == "superserver") {
        runmode = ScriptPref::Superserver;
      } else {
        runmode = ScriptPref::None;
      }

      QDomNode n = docElem.firstChild();
      while (!n.isNull()) {
        QDomElement e = n.toElement();
        if (!e.isNull()) {
          if (!e.tagName().compare("id")) id=e.text().stripWhiteSpace();
          if (!e.tagName().compare("title")) title=e.text().stripWhiteSpace();
          if (!e.tagName().compare("description")) description=e.text().stripWhiteSpace();
          if (!e.tagName().compare("outputfile")) {
            outputfile=e.text().stripWhiteSpace();
            mode = e.attribute("mode","755").stripWhiteSpace();
          }
          if (!e.tagName().compare("scripttemplate")) scripttemplate=e.text().stripWhiteSpace();
          if (!e.tagName().compare("optsep")) optsep=e.text();
          if (!e.tagName().compare("linesep")) linesep=e.text();
        }
        n = n.nextSibling();
      }
      if (!id.isEmpty() && -1==id.find("/") && runmode != ScriptPref::None) {
        bool ok;
        int nmode=mode.toUInt(&ok,8);
        if (!ok) nmode=0644;
        nmode &= 07777;
        m_map[id] = ScriptTemplateItem(runmode, id, title, description,
                                       outputfile, nmode, scripttemplate, optsep,
                                       linesep, 0L);
      }
    } else {
      kdWarning() << "Parsing error for \"" << f.name() << "\" file!" << endl;
    }
    f.close();
  } else {
    kdWarning() << "Cannot open the \"" << f.name() << "\" file!" << endl;
  }
}

void ScriptTemplate::loadAll()
{
  KStandardDirs *dirs = KGlobal::dirs();
  QStringList list = dirs->findAllResources("data","kcmpureftpdscript/*.puretpl",false,true);

  for (QStringList::Iterator it=list.begin(); it!=list.end(); ++it)
    load(*it);
}

void ScriptTemplate::save(ScriptTemplateItem &item)
{
  item=item;
}

void ScriptTemplate::saveAll()
{
}

void ScriptTemplate::clear()
{
  m_map.clear();
}

ScriptTemplateItemIterator ScriptTemplate::begin()
{
  return m_map.begin();
}

ScriptTemplateItemIterator ScriptTemplate::end()
{
  return m_map.end();
}

int ScriptTemplate::count()
{
  return m_map.count();
}
