/***************************************************************************
                         scripttemplate.h  - manage a script template
                         -------------------
    begin                : Sun Jul 27 2003
    copyright            : (C) 2003 by Claudiu Costin
    email                : claudiuc@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __SCRIPTTEMPLATE_H__
#define __SCRIPTTEMPLATE_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <qstring.h>
#include <qmap.h>

#include <klistview.h>

#include "scriptpref.h"


class ScriptTemplateItem {

public:
    ScriptTemplateItem() : m_runmode(ScriptPref::None), m_id(QString::null),
                   m_title(QString::null), m_description(QString::null),
                   m_outputfile(QString::null),
                   m_outputfilemode(0), m_scripttemplate(QString::null),
                   m_optsep(QString::null), m_linesep(QString::null),
                   m_li(0L)
                   {}
    ScriptTemplateItem(const ScriptTemplateItem &item) :
                   m_runmode(item.m_runmode), m_id(item.m_id), m_title(item.m_title),
                   m_description(item.m_description), m_outputfile(item.m_outputfile),
                   m_outputfilemode(item.m_outputfilemode), m_scripttemplate(item.m_scripttemplate),
                   m_optsep(item.m_optsep), m_linesep(item.m_optsep),
                   m_li(item.m_li)
                   {}
    ScriptTemplateItem(ScriptPref::RunMode runmode, const QString &id,
               const QString &title, const QString &description,
               const QString &outputfile, int outputfilemode, const QString &scripttemplate,
               const QString &optsep, const QString &linesep,
               KListViewItem *li) :
               m_runmode(runmode), m_id(id), m_title(title),
               m_description(description), m_outputfile(outputfile),
               m_outputfilemode(outputfilemode), m_scripttemplate(scripttemplate),
               m_optsep(optsep), m_linesep(linesep), m_li(li)
               {}

    ScriptPref::RunMode runmode();
    QString id();
    QString title();
    QString description();
    QString outputfile();
    int outputfilemode();
    QString scripttemplate();
    QString optsep();
    QString linesep();
    KListViewItem *li();
    void setLi(KListViewItem *);

public:
    ScriptPref::RunMode m_runmode;
    QString m_id, m_title, m_description, m_outputfile;
    int m_outputfilemode;
    QString m_scripttemplate, m_optsep, m_linesep;
    KListViewItem *m_li;
};


typedef QMap<QString,ScriptTemplateItem> ScriptTemplateItemMap;
typedef ScriptTemplateItemMap::Iterator ScriptTemplateItemIterator;

class ScriptTemplate {
  public:
    ScriptTemplate();
    ScriptTemplateItemMap& map();
    void load(const QString &file);
    void loadAll();
    void save(ScriptTemplateItem &item);
    void saveAll();
    void clear();
    ScriptTemplateItemIterator begin();
    ScriptTemplateItemIterator end();
    int count();

  private:
    ScriptTemplateItemMap m_map;
};

#endif

