/***************************************************************************
                          configurewizard.h  -  description
                             -------------------
    begin                : Mon Feb 12 2001
    copyright            : (C) 2001 by Javier Campos Morales
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGUREWIZARD_H
#define CONFIGUREWIZARD_H

#include <kdialogbase.h>

#include <klistview.h>
#include <kprocess.h>

/**Configure wizard options
  *@author Javier Campos Morales
  */

class ConfigureWizard : public KDialogBase  {
   Q_OBJECT
public: 
	ConfigureWizard(QWidget *parent=0, const char *name=0, const QString filePath = QString::null);
	~ConfigureWizard();
  /** Get arguments of configure */
  QString getArguments();
private: // Private methods
  /** No descriptions */
  void initGUI();
	/** Help commands */
	void initHELP(const QString &filePath);
  /** Add item from configure --help */
  void addItem();
  /** Write config settings */
  void configWrite();
  /** Read the config settings */
  void configRead();
	/** Main list view options */
	KListView *mainOptions;
	/** Stream line */
	QString streamLine;
	/** Shell process configure --help */
	KShellProcess q;
private slots: // Private slots
  /** No descriptions */
  void slotOutputMessages(KProcess*,char *buffer,int buflen);
  /** No descriptions */
  void slotItemModify(QListViewItem *);
protected slots: // Protected slots
  /** Finish dialog */
  void slotOk();
};

#endif
