/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                        *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KDARINTERACTION_H_
#define _KDARINTERACTION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <dar/libdar.hpp>

class controller;

/**
 * This is the implementation of libdar's pure virtual user_interaction
 * class.
 *
 * @short KDar user_interaction implementation.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 2.0.0
 */
class KDarInteraction : public libdar::user_interaction
{
public:

    /**
     * Constructor
     *
     * @param[in] aController Pointer to the global controller.
     *            It has access to the password if the archive
     *            uses encryption.
     */
    KDarInteraction( controller *aController );
    /**
     * Destructor
     */
    virtual ~KDarInteraction();

    /**
     * Copy constructor
     */
    KDarInteraction( const KDarInteraction & );
    /**
     * Assignment operator
     */
    KDarInteraction & operator=( const KDarInteraction & );

    /**
     * Asks user a question and gives libdar the result
     * via an exception.
     */
    void pause( const std::string & message );
    /**
     * Asks user for a response. Used for getting a password to encrypt or
     * decrypt an archive.
     *
     * @param echo indicates whether KDar should let the response be seen.
     *             This is useful for hiding passwords.
     */
    std::string get_string( const std::string & message, bool echo );
    /**
     * Presents a message to the user.
     */
    void warning( const std::string & message );
    /**
     * Clone method required by libdar. What is this for?
     */
    libdar::user_interaction *clone() const;
    /**
     * Archive listings
     */
    void listing( const std::string & flag, const std::string & perm, const std::string & uid, const std::string & gid, const std::string & size, const std::string & date, const std::string & filename, bool is_dir, bool has_children );

    /**
     * Set the controller pointer
     */
//     void setController( controller * aController );

private:
    controller *m_controller;
};

#endif // _KDARINTERACTION_H_
