/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "diffArchiveThread.h"

#include "kdar.h"
#include "archiveHandle.h"
#include "kdarConfig.h"
#include "kdardeclarations.h"
#include "KDarInteraction.h"
#include "kdarSetCursorEvent.h"
#include "kdarstatistics.h"
#include "kdarStatusBarEvent.h"
#include "kdarWarningEvent.h"

#include <kcursor.h>
#include <klocale.h>

#include <qdatetime.h>

#include <dar/libdar.hpp>
#include <string>

extern bool libdarWorking;
extern libdar::archive *theArchive;

diffArchiveThread::diffArchiveThread( controller * aController, KDarConfig * kdarconfig, KListView * archiveFileView )
    : KDarThread( aController, kdarconfig, archiveFileView )
{}

diffArchiveThread::~diffArchiveThread()
{
}

void diffArchiveThread::run()
{
    //Every class that is derived from KDarThread must set this member variable:
    m_threadID = pthread_self();

    libdarWorking = true;
    QDateTime startTime = QDateTime::currentDateTime();
    openLogFile();
    setWaitCursor();
    enableCancelButton();
    logMessage( "\n" + i18n( "BEGIN COMPARE: " ) + QDateTime::currentDateTime().toString( "ddd dd MMM yyyy hh:mm:ss" ) + " " + m_kdc->archiveName() + "\n", true );
    logMessage( i18n( "command line: " ) + m_kdc->buildDarCommandLine( KDar::LIBDAR_DIFF ) + "\n", true );
    statusMessage( i18n( "Comparing contents of archive with filesystem...\n" ), FOREVER );

    //Need some way to interact with user:
    KDarInteraction userInteractionDialog( m_controller );

    //for file filters
    libdar::et_mask selection;// = new et_mask();
    selection.add_mask(libdar::bool_mask(true));
    //Directory filters from config module:
    libdar::et_mask subtree;
//    libdar::et_mask subtree = m_kdc->libdarCreateDirectoryMask();
    //Include just items that are selected in the archive Browser, if any.
    libdar::ou_mask subIncludes = buildDirectoryMaskFromListView( m_kdc->diffArchiveDirectory() + "/" );
    if ( subIncludes.size() > 0 )
    {
        subtree.add_mask( subIncludes );
    }
    else
    {
        subtree.add_mask( libdar::bool_mask( true ) );
    }
    libdar::path fs_root( kdar::toStdString( m_kdc->diffArchiveDirectory() ) );
    try
    {
// TODO store in KDarConfig:
        bool alterAccesstime = false;
// EndTODO
        KDarStatistics ks = theArchive->op_diff( userInteractionDialog, fs_root, selection, subtree, m_kdc->verbose(), m_kdc->systemEA(), m_kdc->userEA(), m_kdc->ignoreID(), alterAccesstime );

        logMessage( ks.diffStatistics( (KDar::logLevel) m_kdc->logLevel() ) );
        statusMessage( i18n( "Comparing contents of archive with filesystem...done.\n" ) );
        logMessage( timeDifference( startTime, QDateTime::currentDateTime() ) );
    }
    catch( libdar::Euser_abort &e )
    {
        QString errorMessage = i18n( "Comparing contents of archive with filesystem...cancelled by user." );
        statusMessage( errorMessage );
        logMessage( errorMessage );
    }
    catch( libdar::Egeneric &e )
    {
        userInteractionDialog.warning( e.get_message() );
        QString errorMessage = i18n( "Comparing contents of archive with filesystem...ERROR: could not perform comparison." );
        statusMessage( errorMessage );
        logMessage( e.get_message().c_str() );
        logMessage( errorMessage );
    }
    setNormalCursor();
    disableCancelButton();
    m_endMessage = i18n( "END COMPARE: " ) + QDateTime::currentDateTime().toString( "ddd dd MMM yyyy hh:mm:ss" ) + " " + m_kdc->archiveName() + "\n";
    libdarWorking = false;
    deleteMe();
}

