/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _DIFFARCHIVETHREAD_H_
#define _DIFFARCHIVETHREAD_H_

#include "kdarthread.h"

/**
 * This is the diffArchiveThread class. It runs the
 * libdar:op_diff comparison function, which compares the contents of
 * an archive with the contents of the filesystem from which it was made,
 * or to which it was restored.
 *
 * @short Archive-filesystem comparison thread.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */
class diffArchiveThread : public KDarThread
{

public:
    /**
     * Constructor
     * @param aController the controller responsible for deleting the thread.
     * @param kdarconfig the configuration object (main, create or restore) for this
     * thread.
     */
    diffArchiveThread( controller * aController, KDarConfig * kdarconfig, KListView * archiveFileView );
    ~diffArchiveThread();

    void run();

};

#endif // _DIFFARCHIVETHREAD_H_
