/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                        *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "isolateArchiveThread.h"

#include "kdar.h"
#include "kdardeclarations.h"
#include "archiveHandle.h"
#include "kdarConfig.h"
#include "kdardeletethreadevent.h"
#include "KDarInteraction.h"
#include "kdarSetCursorEvent.h"
#include "kdarStatusBarEvent.h"

#include <kcursor.h>
#include <kdebug.h>
#include <klocale.h>

#include <dar/libdar.hpp>
#include <string>

extern bool libdarWorking;
extern libdar::archive *theArchive;

isolateArchiveThread::isolateArchiveThread( controller * aController, KDarConfig * kdarconfig )
    : KDarThread( aController, kdarconfig )
{}

isolateArchiveThread::~isolateArchiveThread()
{}

void isolateArchiveThread::run()
{
    //Every class that is derived from KDarThread must set this member variable:
    m_threadID = pthread_self();

    kdDebug() << "isolateArchiveThread::run(): theArchive = " << theArchive << endl;
    libdarWorking = true;
    setWaitCursor();
    enableCancelButton();
    openLogFile();
    if ( !theArchive )
    {
        disableCancelButton();
        setNormalCursor();
        libdarWorking = false;
        statusMessage( i18n( "Could not isolate archive." ) );
        deleteMe();
        return;
    }
    logMessage( "\n" + i18n( "BEGIN ISOLATE: " ) + QDateTime::currentDateTime().toString( "ddd dd MMM yyyy hh:mm:ss" ) + " " + m_kdc->archiveName() + "\n", true );
    logMessage( i18n( "command line: " ) + m_kdc->buildDarCommandLine( KDar::LIBDAR_ISOLATE ) + "\n", true );
    statusMessage( i18n( "Isolating archive...\n" ), FOREVER );

    //Need some way to interact with user:
    KDarInteraction userInteractionDialog( m_controller );

    QString isoArchiveName = m_kdc->isolationArchiveName();

    if ( isoArchiveName[0] == '/' )
    {
        archiveHandle archiveHndl( m_kdc->isolationArchiveName() );
        //isolate the archive
        try
        {
            libdar::archive * isolatedArchive = new libdar::archive( userInteractionDialog, archiveHndl.getArchiveLibdarPath(), theArchive, kdar::toStdString( archiveHndl.getArchiveBasename() ), EXTENSION, m_kdc->allowOverwrite(), m_kdc->warnOnOverwrite(), m_kdc->verbose(), m_kdc->pauseBetweenSlices(), (libdar::compression) m_kdc->compressionAlgorithm(), (libdar::U_I) m_kdc->compressionLevel(), m_kdc->libdarSliceSize(), m_kdc->libdarFirstSliceSize(), kdar::toStdString( m_kdc->executeCommand() ), ( libdar::crypto_algo ) m_kdc->cryptoAlgorithm(), "", ( libdar::U_32 ) m_kdc->cryptoBlockSize(), m_kdc->dryRun() );
            //Inform user
            statusMessage( i18n( "Isolating archive...done.\n" ) );
            //Do we need to keep this archive for anything? If so, do it here.
            //Delete the isolated archive.
            if ( isolatedArchive )
            {
                delete isolatedArchive;
                isolatedArchive = 0;
            }
        }
        catch( libdar::Euser_abort &e )
        {
            QString errorMessage = i18n( "Isolating archive...cancelled by user." );
            statusMessage( errorMessage );
            logMessage( errorMessage );
        }
        catch( libdar::Egeneric &e )
        {
            userInteractionDialog.warning( e.get_message() );
            QString errorMessage = i18n( "Isolating archive...ERROR: could not isolate archive." );
            statusMessage( errorMessage );
            logMessage( e.get_message().c_str() );
            logMessage( errorMessage );
        }
    }
    setNormalCursor();
    disableCancelButton();
    m_endMessage = i18n( "END ISOLATE: " ) + QDateTime::currentDateTime().toString( "ddd dd MMM yyyy hh:mm:ss" ) + " " + m_kdc->archiveName() + "\n";
    libdarWorking = false;
    deleteMe();
}

