/*
 * Copyright (C) 2003,2004 Johnathan Burchill <jkerrb@users.sourceforge.net>
 */

#ifndef _KDAR_H_
#define _KDAR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "kdarcreatedialog.h"
#include "kdarextractdialog.h"
#include "kdarcreatearchivewizard.h"

#include <kaction.h>
#include <kmainwindow.h>

#include <qstring.h>

#include <string>

class controller;
class kdarView;

class KAboutDialog;
class KActionMenu;
class KPrinter;
class KToggleAction;

/**
 * This class serves as the main window for kdar.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 2.0.0
 */
class kdar : public KMainWindow
{
    Q_OBJECT
public:

    /**
     * Constructor
     * @param aController the main KDar Controller
     */
    kdar( controller * aController);
    /**
     * Destructor
     */
    virtual ~kdar();

    /**
     * popup the context menu
     */
    void popupContextMenu( const QPoint & point );
    /**
     * Adds the URL to the recent files menu list.
     */
    void addRecentURL( const KURL & name );
    /**
     * Removes the URL from the recent files menu list.
     */
    void removeRecentURL( const KURL & name );
    /**
     * Restores the recent files entries from the config file.
     */
    void restoreRecentURLEntries( KConfig * config );
    /**
     * Saves the recent files entries to the config file.
     */
    void saveRecentURLEntries( KConfig * config );
    /**
     * Sets the state of the cancel button.
     *
     * @param state Set this to true to enable use of the cancel action,
     * and set it to false to disable use of the cancel action. This applies
     * to all cancel actions ( menu, toolbar, keyboard shortcuts, etc.).
     */
    void setCancelButtonState( bool state );

    /**
     * To get around the compilation problems with QT versions defining
     * QT_NO_STL. What a pain.
     */
    static std::string toStdString( const QString & qstring );

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    virtual void dragEnterEvent( QDragEnterEvent *event );

protected:

public slots:
    /**
     * Put a persistent message on the statusbar.
     */
    void changeStatusbar( const QString& text );
    /**
     * Open an archive with name KURL & name
     */
    void slotArchiveChoose( const KURL & name );

private slots:
    /**
     * Makes sure we delete all heap variables, and save config properties.
     * Called when user clicks on the "x" in main window.
     */
    void myquit();
    /**
     * Prints the file to any medium.
     */
    void filePrint();
    /**
     *
     */
    void optionsShowToolbar();
    /**
     *
     */
    void optionsShowStatusbar();
    /**
     *
     */
    void optionsConfigureKeys();
    /**
     * Allows user to configure the toolbars.
     */
    void optionsConfigureToolbars();
    /**
     * Allows user to configure KDar options.
     */
    void optionsPreferences();
    /**
     *
     */
    void newToolbarConfig();
    /**
     * Toggles the visibility of the log window
     */
    void optionsShowLogWindow();
    /**
     * Change the main window caption.
     */
    void changeCaption( const QString& text );
    /**
     * For a custom "about" dialog
     */
//    void showAboutApplication();

private:
    /**
     *
     */
    void setupAccel();
    /**
     *
     */
    void setupActions();

private:
    //The view
    kdarView *m_view;

    KPrinter *m_printer;
    KAction *m_kdarCancel;
    KToggleAction *m_logWindowAction;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
    KRecentFilesAction *m_recentFilesAction;
    KAboutDialog *m_aboutKDarDialog;
    KActionMenu *contextPopupMenu;
};

#endif // _KDAR_H_
