/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KDARCANCELBUTTONEVENT_H_
#define _KDARCANCELBUTTONEVENT_H_

#include "kdarEnums.h"
#include <qevent.h>

/**
 * This class provides a way to enable and disable the cancel button
 * from any non-GUI thread.
 */

class kdarCancelButtonEvent: public QCustomEvent
{
public:

    /**
     * The ENABLE and DISABLE commands.
     */
    enum cancelButtonCommand
    {
        ENABLE,
        DISABLE
    };

    /**
     * Constructor.
     *
     * @param command the command to run: ENABLE or DISABLE
     */
    kdarCancelButtonEvent( cancelButtonCommand command )
        : QCustomEvent( KDar::CANCELBUTTON ),
          m_command( command )
    {}

    /**
     * Returns the command to run.
     */
    cancelButtonCommand command() const { return m_command; }

private:
    /**
     * The command to run.
     */
    cancelButtonCommand m_command;
};

#endif // _KDARCANCELBUTTONEVENT_H_
