/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef _KDARPROGRESSDIALOG_H_
#define _KDARPROGRESSDIALOG_H_

#include "kdarEnums.h"

#include <qevent.h>
#include <qstring.h>

class kdarProgressDialogEvent : public QCustomEvent
{
public:
    kdarProgressDialogEvent( const QString message, const int field = 0 )
        : QCustomEvent( KDar::PROGRESSDIALOG ),
          m_message( message ),
          m_field( field )
    {}

    QString message() const { return m_message; }
    int field() const { return m_field; }

private:
    const QString m_message;
    const int m_field;

};


 #endif // _KDARPROGRESSDIALOG_H_
