/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
//Essentially copied from k3bsplash.cpp

#include "kdarSplash.h"

#include <qbitmap.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qstring.h>
#include <qtimer.h>
#include <qfontmetrics.h>

#include <kstandarddirs.h>
#include <kapplication.h>
#include <kaboutdata.h>
#include <kmessagebox.h>

KDarSplash::KDarSplash( QWidget* parent, const char* name )
    : QVBox( parent, name, WType_Dialog|WShowModal|WStyle_Customize|WStyle_NoBorder|WDestructiveClose|WStyle_StaysOnTop )
{
    setMargin( 0 );
    setSpacing( 0 );

    picLabel = new QLabel( this );
    picture = QPixmap( locate( "data", "kdar/kdar-splash.png" ) );
    picLabel->setPixmap( picture );
    picLabel->setBackgroundMode( NoBackground );
//    QBitmap mask;
//    mask = picture;
//    picLabel->setMask( mask );
    QLabel* versionLabel = new QLabel( QString( "Version " ) + kapp->aboutData()->version(), this );
    versionLabel->setMargin( 2 );
    versionLabel->setPaletteBackgroundColor( black );
    versionLabel->setPaletteForegroundColor( white );
    versionLabel->setAlignment( AlignCenter );

    QLabel* copyrightLabel = new QLabel( kapp->aboutData()->copyrightStatement(), this );
    copyrightLabel->setMargin( 2 );
    copyrightLabel->setPaletteBackgroundColor( black );
    copyrightLabel->setPaletteForegroundColor( white );
    copyrightLabel->setAlignment( AlignCenter );


//    m_infoBox = new QLabel( this );
//    m_infoBox->setMargin( 2 );
//    m_infoBox->setPaletteBackgroundColor( black );
//    m_infoBox->setPaletteForegroundColor( white );

    QRect r;
    r.setSize( sizeHint() );
    int ps = QApplication::desktop()->primaryScreen();
    r.moveCenter( QApplication::desktop()->screenGeometry( ps ).center() );
    setGeometry( r );
//    QTimer * timer = new QTimer( this );
//    connect( timer, SIGNAL( timeout() ), this, SLOT( updateGUI() ) );
//    timer->start( 100 );
}

KDarSplash::~KDarSplash()
{
}

void KDarSplash::mousePressEvent( QMouseEvent* )
{
        close();
}

void KDarSplash::addInfo( const QString & s )
{
    m_infoBox->setText( s );
    qApp->processEvents();
}

void KDarSplash::updateGUI()
{
    picLabel->update();
}

#include "kdarSplash.moc"
