/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef _KDARDELETETHREADEVENT_H_
#define _KDARDELETETHREADEVENT_H_

#include <qevent.h>
#include <qthread.h>

/**
 * This class signals the controller to wait-for and delete
 * the specified thread.
 *
 * @short "Delete thread" event.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */
class kdarDeleteThreadEvent : public QCustomEvent
{
public:

    /**
     * Constructor
     */
    kdarDeleteThreadEvent( QThread * thread )
        : QCustomEvent( 1009 ),
          m_thread( thread ){}

    /**
     * Returns the pointer to the thread that is asking to be deleted.
     * You must wait for the thread to finish before deleting it.
     */
    QThread* thread() const { return m_thread; }

private:

    /**
     * The pointer to the thread to delete.
     */
    QThread * m_thread;

};


 #endif // _KDARDELETETHREADEVENT_H_
