/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kdarstatistics.h"

KDarStatistics::KDarStatistics( libdar::statistics libdarStats )
{
    m_treated = QString( libdar::deci( libdarStats.treated ).human().c_str() );
    m_hardLinks = QString( libdar::deci( libdarStats.hard_links ).human().c_str() );
    m_skipped = QString( libdar::deci( libdarStats.skipped ).human().c_str() );
    m_ignored = QString( libdar::deci( libdarStats.ignored ).human().c_str() );
    m_tooOld = QString( libdar::deci( libdarStats.tooold ).human().c_str() );
    m_errors = QString( libdar::deci( libdarStats.errored ).human().c_str() );
    m_deleted = QString( libdar::deci( libdarStats.deleted ).human().c_str() );
    m_eaTreated = QString( libdar::deci( libdarStats.ea_treated ).human().c_str() );
    m_total = QString( libdar::deci( libdarStats.total() ).human().c_str() );
}

KDarStatistics::~KDarStatistics()
{}

QString KDarStatistics::createStatistics( KDar::logLevel level )
{
    QString stats;
    switch ( level )
    {
        case KDar::LOG_NONE:
            return QString::null;
            break;
        case KDar::LOG_BASIC:
            stats.append( i18n( "%n inode (file) was saved.\n", "%n inodes (files) were saved.\n", ul_treated() ) );
            stats.append( i18n( "%n file was not saved due to filesystem error.\n", "%n files were not saved due to filesystem errors.\n", ul_errors() ) );
            break;
        case KDar::LOG_FULL:
            stats.append( i18n( "%n inode (file) was saved.\n", "%n inodes (files) were saved.\n", ul_treated() ) );
            stats.append( i18n( "%n file was not saved due to filesystem error.\n", "%n files were not saved due to filesystem errors.\n", ul_errors() ) );
            stats.append( i18n( "%n hardlink was recorded.\n", "%n hardlinks were recorded.\n", ul_hardLinks() ) );
            //stats.append( i18n( "%n file was not saved (no file change).\n", "%n files were not saved (no file changes).\n", ul_skipped() ) );
            stats.append( i18n( "%n file was excluded by filters.\n", "%n files were excluded by filters.\n", ul_ignored() ) );
            stats.append( i18n( "%n file was recorded as deleted from the reference archive.\n", "%n files were recorded as deleted from the reference archive.\n", ul_deleted() ) );
            stats.append( i18n( "Extended Attributes were saved for %n file.\n", "Extended Attributes were saved for %n files.\n", ul_eaTreated() ) );
            break;
        default:
            return QString::null;
    }
    stats.append( i18n( "%n file was considered.\n", "%n files were considered.\n", ul_total() ) );
    return stats;
}

QString KDarStatistics::diffStatistics( KDar::logLevel level )
{
    QString stats;
    switch ( level )
    {
        case KDar::LOG_NONE:
            return QString::null;
            break;
        case KDar::LOG_BASIC:
            stats.append( i18n( "%n file on the filesystem differs from the corresponding file in the archive.\n", "%n files on the filesystem differ from the corresponding files in the archive.\n", ul_errors() ) );
            break;
        case KDar::LOG_FULL:
            stats.append( i18n( "%n file on the filesystem differs from the corresponding file in the archive.\n", "%n files on the filesystem differ from the corresponding files in the archive.\n", ul_errors() ) );
            stats.append( i18n( "%n file was excluded by filters.\n", "%n files were excluded by filters.\n", ul_ignored() ) );
            stats.append( i18n( "%n file failed to be read.\n", "%n files failed to be read.\n", ul_deleted() ) );
            break;
        default:
            return QString::null;
    }
    stats.append( i18n( "%n file was considered.\n", "%n files were considered.\n", ul_total() ) );
    return stats;
}

QString KDarStatistics::isolateStatistics( KDar::logLevel level )
{
    QString stats;
    switch ( level )
    {
        case KDar::LOG_NONE:
            return QString::null;
            break;
        default:
            return QString::null;
    }
}

QString KDarStatistics::restoreStatistics( KDar::logLevel level )
{
    QString stats;
    switch ( level )
    {
        case KDar::LOG_NONE:
            return QString::null;
            break;
        case KDar::LOG_BASIC:
            stats.append( i18n( "%n inode (file) was restored.\n", "%n inodes (files) were restored.\n", ul_treated() ) );
            stats.append( i18n( "%n file was not restored due to filesystem error.\n", "%n files were not restored due to filesystem errors.\n", ul_errors() ) );
            break;
        case KDar::LOG_FULL:
            stats.append( i18n( "%n inode (file) was restored.\n", "%n inodes (files) were restored.\n", ul_treated() ) );
            stats.append( i18n( "%n file was not restored due to filesystem error.\n", "%n files were not restored due to filesystem errors.\n", ul_errors() ) );
            stats.append( i18n( "%n file was not restored because it was not in the archive.\n", "%n files were not restored because they were not in the archive.\n", ul_skipped() ) );
            stats.append( i18n( "%n file was excluded by filters.\n", "%n files were excluded by filters.\n", ul_ignored() ) );
            stats.append( i18n( "%n file was less recent than the corresponding file on the filesystem.\n", "%n files were less recent than the corresponding files on the filesystem.\n", ul_tooOld() ) );
            stats.append( i18n( "%n file was deleted from the filesystem.\n", "%n files were deleted from the filesystem.\n", ul_deleted() ) );
            stats.append( i18n( "Extended Attributes were restored for %n file.\n", "Extended Attributes were restored for %n files.\n", ul_eaTreated() ) );
            break;
        default:
            return QString::null;
    }
    stats.append( i18n( "%n file was considered.\n", "%n files were considered.\n", ul_total() ) );
    return stats;
}

QString KDarStatistics::testStatistics( KDar::logLevel level )
{
    QString stats;
    switch ( level )
    {
        case KDar::LOG_NONE:
            return QString::null;
            break;
        case KDar::LOG_BASIC:
            stats.append( i18n( "%n file failed CRC check.\n", "%n files failed CRC check.\n", ul_errors() ) );
            break;
        case KDar::LOG_FULL:
            stats.append( i18n( "%n file failed CRC check.\n", "%n files failed CRC check.\n", ul_errors() ) );
            stats.append( i18n( "%n file was excluded by filters.\n", "%n files were excluded by filters.\n", ul_ignored() ) );
            break;
        default:
            return QString::null;
    }
    stats.append( i18n( "%n file was considered.\n", "%n files were considered.\n", ul_total() ) );
    return stats;
}

QString KDarStatistics::treated()
{
    return m_treated;
}

QString KDarStatistics::hardLinks()
{
    return m_hardLinks;
}

QString KDarStatistics::skipped()
{
    return m_skipped;
}

QString KDarStatistics::ignored()
{
    return m_ignored;
}

QString KDarStatistics::tooOld()
{
    return m_tooOld;
}

QString KDarStatistics::errors()
{
    return m_errors;
}

QString KDarStatistics::deleted()
{
    return m_deleted;
}

QString KDarStatistics::eaTreated()
{
    return m_eaTreated;
}

QString KDarStatistics::total()
{
    return m_total;
}

unsigned long KDarStatistics::ul_treated()
{
    return treated().toULong();
}

unsigned long KDarStatistics::ul_hardLinks()
{
    return hardLinks().toULong();
}

unsigned long KDarStatistics::ul_skipped()
{
    return treated().toULong();
}

unsigned long KDarStatistics::ul_ignored()
{
    return ignored().toULong();
}

unsigned long KDarStatistics::ul_tooOld()
{
    return tooOld().toULong();
}

unsigned long KDarStatistics::ul_errors()
{
    return errors().toULong();
}

unsigned long KDarStatistics::ul_deleted()
{
    return deleted().toULong();
}

unsigned long KDarStatistics::ul_eaTreated()
{
    return eaTreated().toULong();
}

unsigned long KDarStatistics::ul_total()
{
    return total().toULong();
}

