/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _LISTARCHIVETHREAD_H_
#define _LISTARCHIVETHREAD_H_

#include "kdarthread.h"

/**
 * This is the listArchiveThread class. It populates the
 * "archive name" in the archive browser with the archive's top-level
 * directories and files.
 *
 * @short Initial archive listing thread
 * @author Johnathan Burchill, <jkerrb@users.sourceforge.net>
 * @version VERSION
 */


class listArchiveThread : public KDarThread
{

public:
    /**
     * Constructor
     *
     * @param aController the controller responsible for deleting this
     * thread
     * @param kdarconfig  the main configuration object
     */
    listArchiveThread( controller * aController, KDarConfig * kdarconfig );
    /**
     * Destructor
     */
    ~listArchiveThread();

    /**
     * The actual listing implementation.
     */
    void run();

};


#endif // _LISTARCHIVETHREAD_H_

