/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "populateTreeArchiveThread.h"

#include "kdar.h"
#include "controller.h"
#include "kdarConfig.h"
#include "kdarArchiveBrowserUpdatesEvent.h"
#include "KDarInteraction.h"
#include "kdarListViewItem.h"
#include "kdarSetCursorEvent.h"
#include "kdarStatusBarEvent.h"
#include "kdarWarningEvent.h"

#include <kcursor.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <klistview.h>
#include <klocale.h>

#include <qapplication.h>
#include <qstring.h>
#include <qpixmap.h>

#include <dar/libdar.hpp>
#include <dar/tools.hpp>
#include <dar/erreurs.hpp>

#include <string>

extern bool libdarWorking;
extern kdarListViewItem *currentDirectory;

extern libdar::archive *theArchive;

populateTreeArchiveThread::populateTreeArchiveThread( controller * aController, QListViewItem * directory )
    : KDarThread( aController, 0 ),
      m_directory( directory )
{}

populateTreeArchiveThread::~populateTreeArchiveThread()
{
}

void populateTreeArchiveThread::run()
{
    //Every class that is derived from KDarThread must set this member variable:
    m_threadID = pthread_self();

    kdDebug() << "populateTreeArchiveThread::run() reached." << endl;
    if ( !theArchive ) return;
    libdarWorking = true;
    setWaitCursor();
    kdarListViewItem *expandItem = static_cast<kdarListViewItem *>( m_directory );
    kdDebug() << "populateTreeArchiveThread::run(): expandItem's text is " << expandItem->text( 0 ) << endl;
    QString path = expandItem->path();
    kdDebug() << "populateTreeArchiveThread::run(): expandItem's path is " << expandItem->path() << endl;
    currentDirectory = expandItem;
    //Disable archive browser updates:
    disableBrowser();
    //Need some way to interact with user:
    KDarInteraction userInteractionDialog( m_controller );
    try
    {
        kdDebug() << "populateTreeArchiveThread::run() trying get_children_of" << endl;
        theArchive->get_children_of( userInteractionDialog, kdar::toStdString( expandItem->path() ) );
    }
    catch( libdar::Euser_abort &e )
    {
        QString errorMessage = i18n( "Populating browser tree...cancelled by user." );
        statusMessage( errorMessage );
    }
    catch( libdar::Egeneric &e )
    {
        userInteractionDialog.warning( e.get_message() );
    }
    setNormalCursor();
    //Enable archive browser updates:
    enableBrowser();
    libdarWorking = false;
    kdDebug() << "populateTreeArchiveThread::run() deleting..." << endl;
    deleteMe();
}
