/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _RESTOREARCHIVETHREAD_H_
#define _RESTOREARCHIVETHREAD_H_

#include "kdarthread.h"

class KDarConfig;
class kdar;

class KListView;

/**
 * This is the restoreArchiveThread class. It runs the
 * libdar:op_extract restoration function, which restores the contents
 * of an archive to the filesystem.
 *
 * @short Archive restoration thread.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */
class restoreArchiveThread : public KDarThread {

public:
    /**
     * Constructor
     * @param aController the controller responsible for deleting the thread.
     * @param kdarconfig the configuration object (main, create or restore) for this
     * thread.
     * @param archiveFileView the archive browser KListView.
     */
    restoreArchiveThread( controller * aController, KDarConfig * kdarconfig, KListView* archiveFileView );
    ~restoreArchiveThread();

    void run();

private:

};



#endif // _RESTOREARCHIVETHREAD_H_
