/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DBUSSERVICE_H
#define DBUSSERVICE_H

#include <qstring.h>

#include "dbusexceptions.h"
#include "dbusitem.h"

class QDBusProxy;

/**
 * Represents a DBus service.
 */
class DBusService
 : public DBusItem
{
public:
    /**
     * @param parent    Parent QListView
     * @param name      Name of this service
     * @param proxy     QDBusProxy to use for populate()
     */
    DBusService(
      QListView * parent,
      QString const & name,
      QDBusProxy * proxy
    );

    ~DBusService();

    /**
     * Populate with all DBUS interfaces, objects etc. returned
     * by org.freedesktop.DBus.Introspectable.Introspect .
     */
    void populate() throw(
      QDBusConnectError,
      QDBusXmlError,
      QDBusSendError
    );

    /**
     * @see DBusItem::widget
     */
    QWidget * widget( QWidget * parent ) const;

private:
    class Private; Private * d;

    /// Not implemented.
    DBusService( DBusService const & other );

    /// Not implemented.
    const DBusService & operator=( DBusService const & other);
};

#endif
