/* Synaescope - a pretty noatun visualization (based on P. Harrison's Synaesthesia)
   Copyright (C) 1997 Paul Francis Harrison <pfh@yoyo.cc.monash.edu.au>
                 2001 Charles Samuels <charles@kde.org>

	this file is X11 source
 */

#include "synaescope.h"
#include "cmodule.h"

#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kstandarddirs.h>

extern "C"
{
	Plugin *create_plugin()
	{
		KGlobal::locale()->insertCatalog("synaescope");
		return new SynaeScope();
	}
}

SynaeScope::SynaeScope() : Plugin(), scopeExePath(0)
{
	kDebug(66666) << k_funcinfo << endl;
	restarting=false;
	connect(&process, SIGNAL(processExited(K3Process *)),
		this, SLOT(processExited(K3Process *)));
	connect(&process, SIGNAL(receivedStdout(K3Process *,char *,int)),
		this, SLOT(receivedStdout(K3Process *,char *,int)));
	connect(&process, SIGNAL(receivedStderr(K3Process *,char *,int)),
		this, SLOT(receivedStderr(K3Process *,char *,int)));
}

SynaeScope::~SynaeScope()
{
	kDebug(66666) << k_funcinfo << endl;
	process.kill();
}

void SynaeScope::init()
{
	kDebug(66666) << k_funcinfo << endl;
	mPrefs = new SynaePrefs(this);
	mPrefs->reopen();
	mPrefs->save();
	connect(mPrefs, SIGNAL(configChanged()), this, SLOT(readConfig()));

	scopeExePath = KStandardDirs::findExe("noatunsynaescope.bin");
	if (scopeExePath.isEmpty())
	{
		KMessageBox::error(0, i18n("Unable to locate noatunsynaescope.bin in your path. Check your installation."));
		unload();
	}

	process << scopeExePath;

	runScope();
}

void SynaeScope::runScope()
{
	kDebug(66666) << k_funcinfo << endl;
	if(!process.start(K3Process::NotifyOnExit, (K3Process::Communication)(K3Process::Stdin | K3Process::Stdout)))
	{
		KMessageBox::error(0, i18n("Unable to start noatunsynaescope. Check your installation."));
		unload();
	}
}


void SynaeScope::readConfig()
{
	kDebug(66666) << k_funcinfo << endl;
	if (!process.isRunning())
		return;

	restarting=true;
	process.kill();
}

void SynaeScope::processExited(K3Process *)
{
	kDebug(66666) << k_funcinfo << endl;
	if(restarting)
	{
		restarting=false;
		runScope();
	}
	else
	{
		unload();
	}
}

void SynaeScope::receivedStdout(K3Process *, char *buf, int len)
{
	QCString debugString(buf,len);
	kDebug(66666) << k_funcinfo << debugString << endl;
}

void SynaeScope::receivedStderr(K3Process *, char *buf, int len)
{
	QCString debugString(buf,len);
	kDebug(66666) << k_funcinfo << debugString << endl;
}

#include  "synaescope.moc"
