/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2007 Montel Laurent <montel@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#ifndef DESKTOPLINEANALYZER
#define DESKTOPLINEANALYZER

#define STRIGI_IMPORT_API
#include <strigi/streamlineanalyzer.h>
#include <strigi/analyzerplugin.h>
#include <strigi/fieldtypes.h>
#include <strigi/analysisresult.h>

#include <QString>

namespace Strigi {
    class RegisteredField;
}
class DesktopLineAnalyzerFactory;

class STRIGI_PLUGIN_API DesktopLineAnalyzer
    : public Strigi::StreamLineAnalyzer {
private:
    Strigi::AnalysisResult* analysisResult;
    const DesktopLineAnalyzerFactory* factory;
    QString device;
    QString type;
    QString nameOfDesktopFile;
    QString comment;
    QString mountPoint;
    QString fileSystem;
    bool writable;
    QString fileType;
    QString preferedItem;
    QString linkTo;
    QString mimeTypes;
    bool ready;

public:
    DesktopLineAnalyzer(const DesktopLineAnalyzerFactory* f) :factory(f) {}
    ~DesktopLineAnalyzer() {}
    const char* name() const { return "DesktopLineAnalyzer"; }
    void startAnalysis(Strigi::AnalysisResult*);
    void handleLine(const char* data, uint32_t length);
    void endAnalysis();
    bool isReadyWithStream();
};

class DesktopLineAnalyzerFactory
    : public Strigi::StreamLineAnalyzerFactory {
friend class DesktopLineAnalyzer;
private:
    const Strigi::RegisteredField* typeField;
    const Strigi::RegisteredField* deviceField;
    const Strigi::RegisteredField* nameField;
    const Strigi::RegisteredField* commentField;
    const Strigi::RegisteredField* mountPointField;
    const Strigi::RegisteredField* fileSystemField;
    const Strigi::RegisteredField* writableField;
    const Strigi::RegisteredField* fileTypeField;
    const Strigi::RegisteredField* preferedItemField;
    const Strigi::RegisteredField* linkToField;

    const char* name() const {
        return "DesktopLineAnalyzer";
    }
    Strigi::StreamLineAnalyzer* newInstance() const {
        return new DesktopLineAnalyzer(this);
    }
    void registerFields(Strigi::FieldRegister&);
};

#endif
