/***************************************************************************
                        kanswer.h  -  description
                           -------------------
  begin                : Fri Nov 30 2001
  copyright            : (C) 2001 by Matthias Messmer <bmlmessmer@web.de> &
                                     Carsten Niehaus <cniehaus@gmx.de> &
                                     Robert Gogolok <mail@robert-gogolok.de>

***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KANSWER_H
#define KANSWER_H


// Qt includes

// KDE includes
#include <kdialog.h>
//Added by qt3to4:
#include <QLabel>
#include <QTimerEvent>
#include <QHBoxLayout>

class QGraphicsScene;
class QGraphicsView;
class QHBoxLayout;
class QLabel;
class QTimer;

class KAnimation;

class KPushButton;

/**
 * A small dialog, which gives feedback, if the input was wrong or false.
 * It provides reading several sentences from file and selecting by chance.
 *
 * @author Matthias Messmer & Carsten Niehaus & Robert Gogolok
 */
class KAnswer : public KDialog
{
    Q_OBJECT
    public:
        /**
        * The constructor doesn't need any parameters but the parent,
        * because it will not be used in any other context.
        *
        * @param parent Parent widget for modal functionality
        */
        explicit KAnswer( QWidget *parent );

        // public functions
        /** setting/changing feedback text and pic */
        void setAnswer( int modus );

    public slots:
        /** reimplemented: close the window after some time */
        void timerEvent( QTimerEvent * );
        void accept();
        
        int exec();

    private:
        // private functions
        /** Loads feadback sentences from file */
        void loadAnswers();
        /** Gets a answer by chance for well solved tasks. */
        QString getRightAnswer();
        /** Gets a answer by chance for not solved tasks. */
        QString getWrongAnswer();

        // GUI widgets
        /** Label for the answer text */
        QLabel *TextLabelAnswer;
        /** OK button */
        KPushButton *ButtonOK;

        /** List of feedback text for well solved tasks. */
        QStringList rightAnswerList;
        /** List of feedback text for not solved tasks. */
        QStringList wrongAnswerList;

        QHBoxLayout *mainLayout;

        KAnimation *right_animation;
        KAnimation *wrong_animation;
        
        int advPer;

        QGraphicsView *m_graphicsView;
		QGraphicsScene *m_graphicsScene;
		QTimer *m_sceneAdvanceTimer;

        void setupSprite();
};

#endif
