/* Yo Emacs, this -*- C++ -*-

  Copyright (C) 1999,2000 Jens Hoefkens
  jens@hoefkens.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "kbgtextview.moc"
#include "kbgtextview.h"

#include <klocale.h>
#include <kconfig.h>
#include <kfontdialog.h>
#include <QFont>

#include <iostream>
#include <kglobal.h>

// == advanced text control ====================================================

/*
 * Constructor
 */
KBgTextView::KBgTextView(QWidget *parent, const char *name)
	: KTextBrowser(parent, name)
{
	clear();
#ifdef __GNUC__
#warning "kde4: porting!!!!!!!!!\n"
#endif
	//setLinkUnderline(true);
}

/*
 * Destructor
 */
KBgTextView::~KBgTextView()
{
	// empty
}

/*
 * Write the string l to the TextView and put the cursor at the end of
 * the current text
 */
void KBgTextView::write(const QString &l)
{
	append("<font face=\"" + font().family() + "\">" + l + "</font><br>\n");
	QTextCursor cursor = textCursor();
	cursor.movePosition (QTextCursor::End);
}

/*
 * Open a font-selection dialog.
 */
void KBgTextView::selectFont()
{
	QFont f = font();
	KFontDialog::getFont(f, false, this, true);
	setFont(f);
}

/*
 * Restore the previously stored settings
 */
void KBgTextView::readConfig()
{
	KSharedConfig::Ptr config = KGlobal::config();
	config->setGroup(objectName());

	// nothing to restore
}

/*
 * Save the current settings to disk
 */
void KBgTextView::saveConfig()
{
	KSharedConfig::Ptr config = KGlobal::config();
	config->setGroup(objectName());

	// nothing to save
}

// EOF
